/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.ext.DataThrowable;
import org.noear.solon.ext.RunnableEx;

public class Action
extends HandlerAide
implements Handler {
    private final BeanWrap bWrap;
    private final HandlerAide bAide;
    private Render bRender;
    private final boolean mIsMain;
    private final MethodWrap mWrap;
    private String mProduces;
    private String mConsumes;
    private final String mName;
    private final boolean mRemoting;
    private PathAnalyzer pathAnalyzer;
    private List<String> pathKeys;
    private static Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public Action(BeanWrap bWrap, HandlerAide bAide, Method method, Mapping mapping, String path, boolean remoting, Render render) {
        this.bWrap = bWrap;
        this.bAide = bAide;
        this.mWrap = MethodWrap.get(method);
        this.mRemoting = remoting;
        this.bRender = render;
        if (this.bRender == null && Render.class.isAssignableFrom(bWrap.clz())) {
            this.bRender = (Render)bWrap.raw();
        }
        if (mapping == null) {
            this.mName = method.getName();
            this.mIsMain = true;
        } else {
            this.mProduces = mapping.produces();
            this.mConsumes = mapping.consumes();
            this.mName = mapping.value();
            boolean bl = this.mIsMain = !mapping.after() && !mapping.before();
        }
        if (path != null && path.indexOf("{") >= 0) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = new PathAnalyzer(path);
            }
        }
    }

    public String name() {
        return this.mName;
    }

    public MethodWrap method() {
        return this.mWrap;
    }

    public BeanWrap bean() {
        return this.bWrap;
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (Utils.isNotEmpty(this.mConsumes) && (x.contentType() == null || !x.contentType().contains(this.mConsumes))) {
            x.statusSet(415);
            return;
        }
        this.invoke(x, null);
    }

    public void invoke(Context x, Object obj) throws Throwable {
        x.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bWrap.get();
            }
            if (this.mIsMain) {
                x.attrSet("controller", obj);
                x.attrSet("action", this);
            }
            this.invoke0(x, obj);
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            x.attrSet("error", ex);
            this.renderDo(ex, x);
            EventBus.push(ex);
        }
    }

    protected void invoke0(Context x, Object obj) throws Throwable {
        if (this.mIsMain) {
            this.handleDo(x, () -> {
                for (Handler h : this.bAide.befores) {
                    h.handle(x);
                }
                for (Handler h : this.befores) {
                    h.handle(x);
                }
            });
        }
        if (!x.getHandled()) {
            this.handleDo(x, () -> {
                Matcher pm;
                if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(x.path())).find()) {
                    int len = this.pathKeys.size();
                    for (int i = 0; i < len; ++i) {
                        x.paramSet(this.pathKeys.get(i), pm.group(i + 1));
                    }
                }
                Object tmp = this.callDo(x, obj, this.mWrap);
                if (this.mIsMain) {
                    x.result = tmp;
                    if (!Utils.isEmpty(this.mProduces)) {
                        x.contentType(this.mProduces);
                    }
                    this.renderDo(tmp, x);
                }
            });
        }
        if (this.mIsMain) {
            for (Handler h : this.bAide.afters) {
                h.handle(x);
            }
            for (Handler h : this.afters) {
                h.handle(x);
            }
        }
    }

    protected void handleDo(Context c, RunnableEx runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            c.setHandled(true);
            ex = Utils.throwableUnwrap(ex);
            if (ex instanceof DataThrowable) {
                this.renderDo(ex, c);
            }
            c.attrSet("error", ex);
            this.renderDo(ex, c);
            EventBus.push(ex);
        }
    }

    protected Object callDo(Context ctx, Object obj, MethodWrap mWrap) throws Throwable {
        String ct = ctx.contentType();
        for (ActionExecutor me : Bridge.actionExecutors()) {
            if (!me.matched(ctx, ct)) continue;
            return me.execute(ctx, obj, mWrap);
        }
        return Bridge.actionExecutorDef().execute(ctx, obj, mWrap);
    }

    protected void renderDo(Object result, Context x) throws Throwable {
        if (x.getRendered()) {
            return;
        }
        x.result = result;
        if (this.bRender == null) {
            x.setRendered(true);
            if (result instanceof Throwable) {
                if (x.remoting()) {
                    x.render(result);
                } else {
                    x.statusSet(500);
                    if (Solon.cfg().isDebugMode()) {
                        x.output(Utils.getFullStackTrace((Throwable)result));
                    }
                }
            } else {
                x.render(result);
            }
        } else {
            this.bRender.render(result, x);
        }
    }
}

