/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Note;
import org.noear.solon.annotation.ServerEndpoint;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.util.ResourceScaner;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.VarGather;
import org.noear.solon.ext.BiConsumerEx;

public class AopContext
extends BeanContainer {
    private boolean loadDone;
    private Set<Runnable> loadEvents = new LinkedHashSet<Runnable>();

    public AopContext() {
        this.initialize();
    }

    protected void initialize() {
        this.beanBuilderAdd(Configuration.class, (clz, bw, anno) -> {
            Inject typeInj = clz.getAnnotation(Inject.class);
            if (typeInj != null && Utils.isNotEmpty(typeInj.value()) && typeInj.value().startsWith("${")) {
                Utils.injectProperties(bw.raw(), Solon.cfg().getPropByExpr(typeInj.value()));
            }
            for (Method m : ClassWrap.get(bw.clz()).getMethods()) {
                Bean m_an = m.getAnnotation(Bean.class);
                if (m_an == null) continue;
                MethodWrap mWrap = MethodWrap.get(m);
                this.tryBuildBean(m_an, mWrap, bw, p1 -> {
                    Inject tmp = p1.getAnnotation(Inject.class);
                    if (tmp == null) {
                        return null;
                    }
                    return tmp.value();
                });
            }
            this.addBeanShape(clz, bw);
            for (Annotation a1 : clz.getAnnotations()) {
                if (anno instanceof Import) {
                    this.beanImport((Import)((Object)anno));
                    continue;
                }
                this.beanImport(anno.annotationType().getAnnotation(Import.class));
            }
        });
        this.beanBuilderAdd(Component.class, (clz, bw, anno) -> {
            HandlerLoader bww;
            bw.nameSet(anno.value());
            bw.tagSet(anno.tag());
            bw.attrsSet(anno.attrs());
            bw.typedSet(anno.typed());
            this.addBeanShape(clz, bw);
            bw.remotingSet(anno.remoting());
            this.beanRegister(bw, anno.value(), anno.typed());
            if (bw.remoting() && (bww = new HandlerLoader(bw)).mapping() != null) {
                bww.load(Solon.global());
            }
        });
        this.beanBuilderAdd(Controller.class, (clz, bw, anno) -> new HandlerLoader(bw).load(Solon.global()));
        this.beanInjectorAdd(Inject.class, (fwT, anno) -> this.beanInject(fwT, anno.value()));
        this.beanBuilderAdd(ServerEndpoint.class, (clz, wrap, anno) -> {
            if (Listener.class.isAssignableFrom(clz)) {
                Listener l = (Listener)wrap.raw();
                Solon.global().router().add(anno.value(), anno.method(), l);
            }
        });
    }

    private void addBeanShape(Class<?> clz, BeanWrap bw) {
        Mapping mapping;
        if (Plugin.class.isAssignableFrom(clz)) {
            Solon.global().plug((Plugin)bw.raw());
            return;
        }
        if (EventListener.class.isAssignableFrom(clz)) {
            this.addEventListener(clz, bw);
            return;
        }
        if (LoadBalance.Factory.class.isAssignableFrom(clz)) {
            Bridge.upstreamFactorySet((LoadBalance.Factory)bw.raw());
        }
        if (Handler.class.isAssignableFrom(clz) && (mapping = clz.getAnnotation(Mapping.class)) != null) {
            Handler handler = (Handler)bw.raw();
            Solon.global().add(mapping, handler);
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        for (Type t1 : clz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t1 instanceof ParameterizedType) || (pt = (ParameterizedType)t1).getRawType() != EventListener.class) continue;
            Class et = (Class)pt.getActualTypeArguments()[0];
            EventBus.subscribe(et, (EventListener)bw.raw());
            return;
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Map.Entry<String, FieldWrap> kv : clzWrap.getFieldAllWraps().entrySet()) {
            Annotation[] annS = kv.getValue().annoS;
            if (annS.length <= 0) continue;
            VarHolder varH = kv.getValue().holder(obj);
            this.tryInject(varH, annS);
        }
    }

    public void beanImport(Import anno) {
        if (anno != null) {
            for (Class<?> clz : anno.value()) {
                this.beanMake(clz);
            }
            for (String pkg : anno.scanPackages()) {
                this.beanScan(pkg);
            }
            for (Class<?> src : anno.scanPackageClasses()) {
                this.beanScan(src);
            }
        }
    }

    public void beanScan(Class<?> source) {
        if (source.getPackage() != null) {
            this.beanScan(source.getClassLoader(), source.getPackage().getName());
        }
    }

    public void beanScan(String basePackage) {
        this.beanScan(JarClassLoader.global(), basePackage);
    }

    public void beanScan(ClassLoader classLoader, String basePackage) {
        if (Utils.isEmpty(basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        String dir = basePackage.replace('.', '/');
        ResourceScaner.scan(classLoader, dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = Utils.loadClass(classLoader, className.replace("/", "."));
            if (clz != null) {
                this.tryCreateBean(clz);
            }
        });
    }

    public BeanWrap beanMake(Class<?> clz) {
        BeanWrap bw = this.wrap(clz, null);
        this.tryCreateBean(bw);
        this.putWrap(clz, bw);
        return bw;
    }

    protected void tryInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector bi = (BeanInjector)this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.doInject(varH, a);
        }
    }

    protected void tryCreateBean(Class<?> clz) {
        this.tryCreateBean0(clz, (c, a) -> {
            BeanWrap bw = this.wrap(clz, null);
            c.doBuild(clz, bw, a);
            this.putWrap(clz, bw);
        });
    }

    protected void tryCreateBean(BeanWrap bw) {
        this.tryCreateBean0(bw.clz(), (c, a) -> c.doBuild(bw.clz(), bw, a));
    }

    protected void tryCreateBean0(Class<?> clz, BiConsumerEx<BeanBuilder, Annotation> consumer) {
        Annotation[] annS = clz.getDeclaredAnnotations();
        if (annS.length > 0) {
            try {
                for (Annotation a : annS) {
                    BeanBuilder creator = (BeanBuilder)this.beanBuilders.get(a.annotationType());
                    if (creator == null) continue;
                    consumer.accept(creator, a);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void tryBuildBean(Bean anno, MethodWrap mWrap, BeanWrap bw, Function<Parameter, String> injectVal) throws Exception {
        int size2 = mWrap.getParameters().length;
        if (size2 == 0) {
            Object raw = mWrap.doIntercept(bw.raw(), new Object[0]);
            this.tryBuildBean0(mWrap, anno, raw);
        } else {
            VarGather gather = new VarGather(size2, args2 -> {
                try {
                    Object raw = mWrap.doIntercept(bw.raw(), (Object[])args2);
                    this.tryBuildBean0(mWrap, anno, raw);
                }
                catch (Throwable ex) {
                    EventBus.push(ex);
                }
            });
            for (Parameter p1 : mWrap.getParameters()) {
                VarHolder p2 = gather.add(p1);
                this.beanInject(p2, injectVal.apply(p1));
            }
        }
    }

    protected void tryBuildBean0(MethodWrap mWrap, Bean anno, Object raw) {
        if (raw != null) {
            Class<?> beanClz = mWrap.getReturnType();
            Inject beanInj = mWrap.getAnnotation(Inject.class);
            BeanWrap m_bw = null;
            if (raw instanceof BeanWrap) {
                m_bw = (BeanWrap)raw;
            } else {
                if (beanInj != null && !Utils.isEmpty(beanInj.value()) && beanInj.value().startsWith("${")) {
                    Utils.injectProperties(raw, Solon.cfg().getPropByExpr(beanInj.value()));
                }
                EventBus.push(raw);
                m_bw = new BeanWrap(beanClz, raw);
                m_bw.attrsSet(anno.attrs());
            }
            m_bw.nameSet(anno.value());
            m_bw.tagSet(anno.tag());
            m_bw.typedSet(anno.typed());
            this.beanRegister(m_bw, anno.value(), anno.typed());
            EventBus.push(m_bw);
        }
    }

    @Note(value="\u6dfb\u52a0bean\u52a0\u8f7d\u5b8c\u6210\u4e8b\u4ef6")
    public void beanOnloaded(Runnable fun) {
        this.loadEvents.add(fun);
        if (this.loadDone) {
            fun.run();
        }
    }

    public void beanLoaded() {
        this.loadDone = true;
        this.loadEvents.forEach(f -> f.run());
    }
}

