/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.util.HeaderUtils;

public class Message {
    private final int flag;
    private final String key;
    private final String resourceDescriptor;
    private final String header;
    private Map<String, String> headerMap;
    private final byte[] body;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean _handled;

    @Note(value="1.\u6d88\u606f\u6807\u5fd7\uff08-2\u5fc3\u8df3\u5305, -1\u63e1\u624b\u5305\uff1b0\u53d1\u8d77\u5305\uff1b 1\u54cd\u5e94\u5305\uff09")
    public int flag() {
        return this.flag;
    }

    @Note(value="2.\u6d88\u606fkey")
    public String key() {
        return this.key;
    }

    @Note(value="3.\u8d44\u6e90\u63cf\u8ff0")
    public String resourceDescriptor() {
        return this.resourceDescriptor;
    }

    @Note(value="4.\u6d88\u606f\u5934")
    public String header() {
        return this.header;
    }

    public Map<String, String> headerMap() {
        if (this.headerMap == null) {
            this.headerMap = HeaderUtils.decodeHeaderMap(this.header);
        }
        return Collections.unmodifiableMap(this.headerMap);
    }

    @Note(value="5.\u6d88\u606f\u4e3b\u4f53")
    public byte[] body() {
        return this.body;
    }

    public String bodyAsString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body, this.charset);
    }

    public <T> T map(Function<Message, T> mapper) {
        return mapper.apply(this);
    }

    public Message(int flag, String key, String resourceDescriptor, String header, byte[] body) {
        this.flag = flag;
        this.key = key == null ? "" : key;
        this.resourceDescriptor = resourceDescriptor == null ? "" : resourceDescriptor;
        this.header = header == null ? "" : header;
        this.body = body == null ? new byte[]{} : body;
    }

    public String toString() {
        return "Message{flag=" + this.flag + ", key='" + this.key + '\'' + ", resourceDescriptor='" + this.resourceDescriptor + '\'' + ", header='" + this.header + '\'' + '}';
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public boolean getHandled() {
        return this._handled;
    }
}

