/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.Aop;
import org.noear.solon.core.wrap.ClassWrap;

public class BeanWrap {
    private Class<?> clz;
    private Method clzInit;
    private Object raw;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private String tag;
    private String attrs;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;

    public BeanWrap(Class<?> clz) {
        this(clz, null);
    }

    public BeanWrap(Class<?> clz, Object raw) {
        this.clz = clz;
        Singleton ano = clz.getAnnotation(Singleton.class);
        this.singleton = ano == null || ano.value();
        this.annotations = clz.getAnnotations();
        this.tryBuildInit();
        this.raw = raw == null ? this._new() : raw;
    }

    public BeanWrap(Class<?> clz, Object raw, String attrs) {
        this(clz, raw);
        this.attrsSet(attrs);
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null) {
            this.raw = proxy.getProxy(this.raw);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public <T> T raw() {
        return (T)this.raw;
    }

    protected void rawSet(Object raw) {
        this.raw = raw;
    }

    public String name() {
        return this.name;
    }

    protected void nameSet(String name) {
        this.name = name;
    }

    public String tag() {
        return this.tag;
    }

    protected void tagSet(String tag) {
        this.tag = tag;
    }

    public String attrs() {
        return this.attrs;
    }

    protected void attrsSet(String attrs) {
        this.attrs = attrs;
    }

    public boolean typed() {
        return this.typed;
    }

    protected void typedSet(boolean typed) {
        this.typed = typed;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public <T> T get() {
        if (this.singleton) {
            return (T)this.raw;
        }
        return (T)this._new();
    }

    protected Object _new() {
        if (this.clz.isInterface()) {
            return this.raw;
        }
        try {
            Object obj = this.clz.newInstance();
            Aop.inject(obj);
            if (this.clzInit != null) {
                this.clzInit.invoke(obj, new Object[0]);
            }
            if (this.proxy != null) {
                obj = this.proxy.getProxy(obj);
            }
            return obj;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void tryBuildInit() {
        if (this.clzInit != null) {
            return;
        }
        if (this.clz.isInterface()) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(this.clz);
        for (Method m : clzWrap.getMethods()) {
            if (m.getAnnotation(Init.class) == null) continue;
            if (m.getParameters().length != 0) break;
            this.clzInit = m;
            break;
        }
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(Object var1);
    }
}

