/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.ActionExecutorDefault;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.tran.TranExecutor;

public class Bridge {
    private static SessionState _sessionState = new XSessionStateDefault();
    private static boolean sessionStateUpdated;
    private static LoadBalance.Factory _upstreamFactory;
    private static ActionExecutor _actionExecutorDef;
    private static Set<ActionExecutor> _actionExecutors;
    private static TranExecutor _tranExecutor;

    @Note(value="\u8bbe\u7f6eSession\u72b6\u6001\u7ba1\u7406\u5668")
    public static void sessionStateSet(SessionState ss) {
        if (ss != null) {
            _sessionState = ss;
            if (!sessionStateUpdated) {
                sessionStateUpdated = true;
                Solon.global().before("**", MethodType.HTTP, c -> _sessionState.sessionRefresh());
            }
        }
    }

    @Note(value="\u83b7\u53d6Session\u72b6\u6001\u7ba1\u7406\u5668")
    public static SessionState sessionState() {
        return _sessionState;
    }

    @Note(value="\u83b7\u53d6\u8d1f\u8f7d\u5de5\u5382")
    public static LoadBalance.Factory upstreamFactory() {
        return _upstreamFactory;
    }

    @Note(value="\u8bbe\u7f6e\u8d1f\u8f7d\u5de5\u5382")
    public static void upstreamFactorySet(LoadBalance.Factory uf) {
        if (uf != null) {
            _upstreamFactory = uf;
        }
    }

    @Note(value="\u83b7\u53d6\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static ActionExecutor actionExecutorDef() {
        return _actionExecutorDef;
    }

    @Note(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static void actionExecutorDefSet(ActionExecutor ae) {
        if (ae != null) {
            _actionExecutorDef = ae;
        }
    }

    @Note(value="\u83b7\u53d6\u6240\u6709Action\u6267\u884c\u5668")
    public static Set<ActionExecutor> actionExecutors() {
        return Collections.unmodifiableSet(_actionExecutors);
    }

    @Note(value="\u6dfb\u52a0Action\u6267\u884c\u5668")
    public static void actionExecutorAdd(ActionExecutor e) {
        if (e != null) {
            _actionExecutors.add(e);
        }
    }

    @Note(value="\u6ce8\u518c\u6e32\u67d3\u5668")
    public static void renderRegister(Render render) {
        if (render != null) {
            RenderManager.register(render);
        }
    }

    @Note(value="\u5370\u5c04\u6e32\u67d3\u5173\u7cfb")
    public static void renderMapping(String suffix, Render render) {
        if (suffix != null && render != null) {
            RenderManager.mapping(suffix, render);
        }
    }

    @Note(value="\u5370\u5c04\u6e32\u67d3\u5173\u7cfb")
    public static void renderMapping(String suffix, String className) {
        if (suffix != null && className != null) {
            RenderManager.mapping(suffix, className);
        }
    }

    @Note(value="\u83b7\u53d6\u4e8b\u52a1\u6267\u884c\u5668")
    public static TranExecutor tranExecutor() {
        return _tranExecutor;
    }

    @Note(value="\u8bbe\u7f6e\u4e8b\u52a1\u6267\u884c\u5668")
    public static void tranExecutorSet(TranExecutor te) {
        if (te != null) {
            _tranExecutor = te;
        }
    }

    static {
        _upstreamFactory = null;
        _actionExecutorDef = new ActionExecutorDefault();
        _actionExecutors = new HashSet<ActionExecutor>();
        _tranExecutor = () -> false;
    }

    static class XSessionStateDefault
    implements SessionState {
        XSessionStateDefault() {
        }

        @Override
        public String sessionId() {
            return null;
        }

        @Override
        public Object sessionGet(String key) {
            return null;
        }

        @Override
        public void sessionSet(String key, Object val) {
        }
    }
}

