/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RunUtil {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());

    public static Future<?> parallel(Runnable task) {
        return executor.submit(task);
    }

    public static <T> Future<T> parallel(Callable<T> task) {
        return executor.submit(task);
    }

    public static Future<?> async(Runnable task) {
        return CompletableFuture.runAsync(task);
    }

    public static ScheduledFuture<?> delay(Runnable task, long millis) {
        return scheduledExecutor.schedule(task, millis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> delayAndRepeat(Runnable task, long millis) {
        return scheduledExecutor.scheduleWithFixedDelay(task, 1000L, millis, TimeUnit.MILLISECONDS);
    }
}

