/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.noear.solon.Utils;

public class DownloadedFile {
    @Deprecated
    public String contentType;
    @Deprecated
    public long contentSize;
    @Deprecated
    public InputStream content;
    @Deprecated
    public String name;

    public String getContentType() {
        return this.contentType;
    }

    public long getContentSize() throws IOException {
        if (this.contentSize > 0L) {
            return this.contentSize;
        }
        return this.content.available();
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public DownloadedFile() {
    }

    public DownloadedFile(String contentType, long contentSize, InputStream content, String name) {
        this.contentType = contentType;
        this.contentSize = contentSize;
        this.content = content;
        this.name = name;
    }

    public DownloadedFile(String contentType, InputStream content, String name) {
        this(contentType, 0L, content, name);
    }

    public DownloadedFile(String contentType, byte[] content, String name) {
        this.contentType = contentType;
        this.contentSize = content.length;
        this.content = new ByteArrayInputStream(content);
        this.name = name;
    }

    public void transferTo(File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            Utils.transferTo(this.content, stream);
        }
    }

    public void transferTo(OutputStream stream) throws IOException {
        Utils.transferTo(this.content, stream);
    }
}

