/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.FileNameMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.PropsLoader;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.wrap.ClassWrap;

@Note(value="\u5185\u90e8\u4e13\u7528\u5de5\u5177\uff08\u5916\u90e8\u9879\u76ee\u4e0d\u5efa\u8bae\u4f7f\u7528\uff0c\u968f\u65f6\u53ef\u80fd\u4f1a\u53d8\u52a8\uff09")
public class Utils {
    private static final FileNameMap mimeMap = URLConnection.getFileNameMap();
    @Deprecated
    public static final ExecutorService pools = Executors.newCachedThreadPool();
    public static final ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Future<?> parallel(Runnable task) {
        return pools.submit(task);
    }

    public static <T> Future<T> parallel(Callable<T> task) {
        return pools.submit(task);
    }

    public static Future<?> async(Runnable task) {
        return CompletableFuture.runAsync(task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ping(String address) throws Exception {
        if (!address.contains(":")) return InetAddress.getByName(address).isReachable(3000);
        String host = address.split(":")[0];
        int port = Integer.parseInt(address.split(":")[1]);
        try (Socket socket = new Socket();){
            InetSocketAddress addr = new InetSocketAddress(host, port);
            socket.connect(addr, 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String mime(String fileName) {
        return mimeMap.getContentTypeFor(fileName);
    }

    public static String annoAlias(String v1, String v2) {
        if (Utils.isEmpty(v1)) {
            return v2;
        }
        return v1;
    }

    public static String guid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String md5(String str) {
        try {
            byte[] btInput = str.getBytes("UTF-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] chars = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                chars[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                chars[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(chars);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Collection<String> resolvePaths(String pathExpr) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!pathExpr.contains("/*")) {
            paths.add(pathExpr);
            return paths;
        }
        int dirIdx = pathExpr.indexOf("/*");
        String dir = pathExpr.substring(0, dirIdx);
        int sufIdx = pathExpr.lastIndexOf(".");
        String suf = null;
        if (sufIdx > 0 && (suf = pathExpr.substring(sufIdx)).contains("*")) {
            sufIdx = -1;
            suf = null;
        }
        int sufIdx2 = sufIdx;
        String suf2 = suf;
        String expr = pathExpr.replaceAll("/\\*\\.", "/[^\\.]*\\.");
        expr = expr.replaceAll("/\\*\\*/", "(/[^/]*)*/");
        Pattern pattern = Pattern.compile(expr);
        ScanUtil.scan(dir, n -> {
            if (sufIdx2 > 0) {
                return n.endsWith(suf2);
            }
            return true;
        }).forEach(uri -> {
            if (pattern.matcher((CharSequence)uri).find()) {
                paths.add((String)uri);
            }
        });
        return paths;
    }

    public static String throwableToString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Deprecated
    public static RuntimeException throwableWrap(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        return new RuntimeException(ex);
    }

    public static Throwable throwableUnwrap(Throwable ex) {
        Throwable th = ex;
        while (true) {
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
                continue;
            }
            if (th instanceof UndeclaredThrowableException) {
                th = ((UndeclaredThrowableException)th).getUndeclaredThrowable();
                continue;
            }
            if (th.getClass() != RuntimeException.class || th.getCause() == null) break;
            th = th.getCause();
        }
        return th;
    }

    public static boolean throwableHas(Throwable ex, Class<? extends Throwable> clz) {
        Throwable th = ex;
        while (true) {
            if (clz.isAssignableFrom(th.getClass())) {
                return true;
            }
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
                continue;
            }
            if (th instanceof UndeclaredThrowableException) {
                th = ((UndeclaredThrowableException)th).getUndeclaredThrowable();
                continue;
            }
            if (th.getCause() == null) break;
            th = th.getCause();
        }
        return false;
    }

    public static String trimDuplicates(String str, char c) {
        int start = 0;
        while ((start = str.indexOf(c, start) + 1) > 0) {
            int end;
            for (end = start; end < str.length() && str.charAt(end) == c; ++end) {
            }
            if (end <= start) continue;
            str = str.substring(0, start) + str.substring(end);
        }
        return str;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !Utils.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        if (Utils.isEmpty(s)) {
            return true;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (Utils.isWhitespace(s.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String s) {
        return !Utils.isBlank(s);
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static <T> T firstOrNull(List<T> list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static Locale toLocale(String lang) {
        if (lang == null) {
            return null;
        }
        String[] ss = lang.split("_|-");
        if (ss.length >= 3) {
            if (ss[1].length() > 2) {
                return new Locale(ss[0], ss[2], ss[1]);
            }
            return new Locale(ss[0], ss[1], ss[2]);
        }
        if (ss.length == 2) {
            if (ss[1].length() > 2) {
                return new Locale(ss[0], "", ss[1]);
            }
            return new Locale(ss[0], ss[1]);
        }
        return new Locale(ss[0]);
    }

    public static Class<?> loadClass(String className) {
        try {
            return Utils.loadClass(null, className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T newInstance(String className) {
        return Utils.newInstance(className, null);
    }

    public static <T> T newInstance(String className, Properties prop) {
        return Utils.newInstance(JarClassLoader.global(), className, prop);
    }

    public static <T> T newInstance(ClassLoader classLoader, String className) {
        return Utils.newInstance(classLoader, className, null);
    }

    public static <T> T newInstance(ClassLoader classLoader, String className, Properties prop) {
        try {
            Class<?> clz = Utils.loadClass(classLoader, className);
            if (clz == null) {
                return null;
            }
            return Utils.newInstance(clz, prop);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> T newInstance(Class<?> clz) throws Exception {
        return Utils.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws Exception {
        if (prop == null) {
            return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (T)clz.getConstructor(Properties.class).newInstance(prop);
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        return Utils.getResources(JarClassLoader.global(), name);
    }

    public static Enumeration<URL> getResources(ClassLoader classLoader, String name) throws IOException {
        return classLoader.getResources(name);
    }

    public static URL getResource(String name) {
        return Utils.getResource(JarClassLoader.global(), name);
    }

    public static URL getResource(ClassLoader classLoader, String name) {
        return classLoader.getResource(name);
    }

    public static String getResourceAsString(String name) throws IOException {
        return Utils.getResourceAsString(JarClassLoader.global(), name, Solon.encoding());
    }

    public static String getResourceAsString(String name, String charset) throws IOException {
        return Utils.getResourceAsString(JarClassLoader.global(), name, charset);
    }

    public static String getResourceAsString(ClassLoader classLoader, String name, String charset) throws IOException {
        URL url = Utils.getResource(classLoader, name);
        if (url != null) {
            try (InputStream in = url.openStream();){
                String string = Utils.transferToString(in, charset);
                return string;
            }
        }
        return null;
    }

    public static String transferToString(InputStream ins) throws IOException {
        return Utils.transferToString(ins, Solon.encoding());
    }

    public static String transferToString(InputStream ins, String charset) throws IOException {
        if (ins == null) {
            return null;
        }
        ByteArrayOutputStream outs = Utils.transferTo(ins, new ByteArrayOutputStream());
        if (Utils.isEmpty(charset)) {
            return outs.toString();
        }
        return outs.toString(charset);
    }

    public static byte[] transferToBytes(InputStream ins) throws IOException {
        if (ins == null) {
            return null;
        }
        return Utils.transferTo(ins, new ByteArrayOutputStream()).toByteArray();
    }

    public static <T extends OutputStream> T transferTo(InputStream ins, T out) throws IOException {
        if (ins == null || out == null) {
            return null;
        }
        int len = 0;
        byte[] buf = new byte[512];
        while ((len = ins.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        return out;
    }

    public static Properties loadProperties(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return PropsLoader.global().load(url);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(String url) {
        return Utils.loadProperties(Utils.getResource(url));
    }

    public static Properties buildProperties(String txt) {
        try {
            return PropsLoader.global().build(txt);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T injectProperties(T obj, Properties propS) {
        return PropsConverter.global().convert(propS, obj, null, null);
    }

    public static String getFullStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static String buildExt(String extend, boolean autoMake) {
        int idx;
        if (extend == null) {
            return null;
        }
        if (extend.contains("/")) {
            return extend;
        }
        LogUtil.global().info("Extend config: " + extend);
        URL temp = Utils.getResource("");
        if (temp == null) {
            return null;
        }
        String uri = temp.toString();
        LogUtil.global().info("Resource root: " + uri);
        if (uri.startsWith("file:/")) {
            idx = uri.lastIndexOf("/target/");
            idx = idx > 0 ? (idx += 8) : uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(5, idx);
        } else {
            idx = uri.indexOf("jar!/");
            idx = uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(9, idx);
        }
        uri = uri + extend + "/";
        File dir = new File(uri);
        if (!dir.exists()) {
            if (autoMake) {
                dir.mkdir();
            } else {
                return null;
            }
        }
        return uri;
    }

    public static void bindTo(Map<String, String> source, Object target) {
        Utils.bindTo((String k) -> (String)source.get(k), target);
    }

    public static void bindTo(Properties source, Object target) {
        Utils.injectProperties(target, source);
    }

    public static void bindTo(Function<String, String> source, Object target) {
        if (target == null) {
            return;
        }
        ClassWrap.get(target.getClass()).fill(target, source);
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Utils.getContextClassLoader();
        if (classLoader == null && null == (classLoader = Utils.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

