/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.FilterChainNode;
import org.noear.solon.core.handle.FilterEntity;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.PathUtil;

public abstract class Gateway
extends HandlerAide
implements Handler,
Render {
    private Handler mainDef;
    private final RoutingTable<Handler> mainRouting;
    private final String mapping;
    private Mapping mappingAnno;
    private List<FilterEntity> filterList = new ArrayList<FilterEntity>();

    public Gateway() {
        this(new RoutingTableDefault<Handler>());
    }

    public Gateway(RoutingTable<Handler> routingTable) {
        this.mainRouting = routingTable;
        this.mappingAnno = this.getClass().getAnnotation(Mapping.class);
        if (this.mappingAnno == null) {
            throw new IllegalStateException("No Mapping!");
        }
        this.mapping = Utils.annoAlias(this.mappingAnno.value(), this.mappingAnno.path());
        this.mainDef = c -> c.status(404);
        this.filterList.add(new FilterEntity(Integer.MAX_VALUE, this::doFilter));
        this.register();
    }

    @Note(value="\u6ce8\u518c\u76f8\u5173\u63a5\u53e3\u4e0e\u62e6\u622a\u5668")
    protected abstract void register();

    @Note(value="\u5141\u8bb8 Action Mapping \u7533\u660e")
    protected boolean allowActionMapping() {
        return true;
    }

    @Note(value="\u5145\u8bb8\u63d0\u524d\u51c6\u5907\u63a7\u5236\u5668")
    protected boolean allowReadyController() {
        return true;
    }

    @Note(value="\u5145\u8bb8\u8def\u5f84\u5408\u5e76")
    protected boolean allowPathMerging() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void render(Object obj, Context c) throws Throwable {
        if (c.getRendered()) {
            return;
        }
        if (obj instanceof DataThrowable) {
            return;
        }
        c.result = obj;
        if (!(obj instanceof Throwable)) {
            c.render(obj);
            return;
        }
        if (c.remoting()) {
            EventBus.push(obj);
            if (c.getRendered()) return;
            c.render(obj);
            return;
        }
        c.setHandled(false);
        throw (Throwable)obj;
    }

    public void filter(Filter filter) {
        this.filter(0, filter);
    }

    public void filter(int index, Filter filter) {
        this.filterList.add(new FilterEntity(index, filter));
        this.filterList.sort(Comparator.comparingInt(f -> f.index));
    }

    @Override
    public void handle(Context c) throws Throwable {
        try {
            new FilterChainNode(this.filterList).doFilter(c);
        }
        catch (Throwable e) {
            c.setHandled(true);
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.render(ex, c);
                } else {
                    this.render(ex.data(), c);
                }
            }
            c.errors = e;
            if (c.result == null) {
                this.render(e, c);
            }
            this.render(c.result, c);
        }
    }

    protected void doFilter(Context c, FilterChain chain) throws Throwable {
        Handler m = this.find(c);
        Object obj = null;
        if (m != null) {
            Boolean is_action = m instanceof Action;
            if (is_action.booleanValue()) {
                if (this.allowReadyController()) {
                    obj = ((Action)m).controller().get();
                    c.attrSet("controller", obj);
                }
                c.attrSet("action", m);
            }
            this.handle0(c, m, obj, is_action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle0(Context c, Handler m, Object obj, Boolean is_action) throws Throwable {
        try {
            for (Handler h : this.befores) {
                h.handle(c);
            }
            if (!c.getHandled()) {
                if (is_action.booleanValue()) {
                    ((Action)m).invoke(c, obj);
                } else {
                    m.handle(c);
                }
            } else {
                this.render(c.result, c);
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.render(ex, c);
                }
                this.render(ex.data(), c);
            }
            c.errors = e;
            throw e;
        }
        finally {
            for (Handler h : this.afters) {
                h.handle(c);
            }
        }
    }

    @Note(value="\u6dfb\u52a0\u524d\u7f6e\u62e6\u622a\u5668")
    public <T extends Handler> void before(Class<T> interceptorClz) {
        super.before((Handler)Solon.context().getBeanOrNew(interceptorClz));
    }

    @Note(value="\u6dfb\u52a0\u540e\u7f6e\u62e6\u622a\u5668")
    public <T extends Handler> void after(Class<T> interceptorClz) {
        super.after((Handler)Solon.context().getBeanOrNew(interceptorClz));
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void addBeans(Predicate<BeanWrap> where) {
        this.addBeans(where, false);
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void addBeans(Predicate<BeanWrap> where, boolean remoting) {
        Solon.context().beanOnloaded(ctx -> ctx.beanForeach(bw -> {
            if (where.test((BeanWrap)bw)) {
                if (remoting) {
                    this.add((BeanWrap)bw, remoting);
                } else {
                    this.add((BeanWrap)bw);
                }
            }
        }));
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(Class<?> beanClz) {
        if (beanClz != null) {
            BeanWrap bw = Solon.context().wrapAndPut(beanClz);
            this.add(bw, bw.remoting());
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, Class<?> beanClz) {
        if (beanClz != null) {
            BeanWrap bw = Solon.context().wrapAndPut(beanClz);
            this.add(path, bw, bw.remoting());
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(Class<?> beanClz, boolean remoting) {
        if (beanClz != null) {
            this.add(Solon.context().wrapAndPut(beanClz), remoting);
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, Class<?> beanClz, boolean remoting) {
        if (beanClz != null) {
            this.add(path, Solon.context().wrapAndPut(beanClz), remoting);
        }
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(BeanWrap beanWp) {
        this.add(beanWp, beanWp.remoting());
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, BeanWrap beanWp) {
        this.add(path, beanWp, beanWp.remoting());
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(BeanWrap beanWp, boolean remoting) {
        this.add(null, beanWp, remoting);
    }

    @Note(value="\u6dfb\u52a0\u63a5\u53e3")
    public void add(String path, BeanWrap beanWp, boolean remoting) {
        if (beanWp == null) {
            return;
        }
        Mapping bMapping = beanWp.clz().getAnnotation(Mapping.class);
        String bPath = null;
        if (bMapping != null) {
            bPath = Utils.annoAlias(bMapping.value(), bMapping.path());
        }
        HandlerLoader uw = new HandlerLoader(beanWp, bPath, remoting, this, this.allowActionMapping());
        uw.load((expr, method, handler) -> {
            if (path == null) {
                this.addDo(expr, method, handler);
            } else {
                this.addDo(PathUtil.mergePath(path, expr), method, handler);
            }
        });
    }

    @Note(value="\u6dfb\u52a0\u7f3a\u5c11\u5904\u7406")
    public void add(Handler handler) {
        this.addDo("", MethodType.ALL, handler);
    }

    @Note(value="\u6dfb\u52a0\u4e8c\u7ea7\u8def\u5f84\u5904\u7406")
    public void add(String path, Handler handler) {
        this.addDo(path, MethodType.ALL, handler);
    }

    @Note(value="\u6dfb\u52a0\u4e8c\u7ea7\u8def\u5f84\u5904\u7406")
    public void add(String path, MethodType method, Handler handler) {
        this.addDo(path, method, handler);
    }

    protected void addDo(String path, MethodType method, Handler handler) {
        if (Utils.isEmpty(path) || "/".equals(path)) {
            this.mainDef = handler;
            return;
        }
        if (this.allowPathMerging()) {
            String path2 = PathUtil.mergePath(this.mapping, path);
            this.mainRouting.add(new RoutingDefault<Handler>(path2, method, handler));
        } else {
            this.mainRouting.add(new RoutingDefault<Handler>(path, method, handler));
        }
    }

    protected Handler getDo(Context c, String path) {
        if (path == null) {
            return null;
        }
        MethodType method = MethodType.valueOf(c.method());
        return this.mainRouting.matchOne(path, method);
    }

    protected Handler find(Context c) throws Throwable {
        return this.findDo(c, c.pathNew());
    }

    protected Handler findDo(Context c, String path) throws Throwable {
        Handler h = this.getDo(c, path);
        if (h == null) {
            this.mainDef.handle(c);
            c.setHandled(true);
            return this.mainDef;
        }
        if (h instanceof Action) {
            c.attrSet("handler_name", ((Action)h).fullName());
        }
        return h;
    }
}

