/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.annotation.XController;
import org.noear.solon.annotation.XInject;
import org.noear.solon.annotation.XInterceptor;
import org.noear.solon.annotation.XNote;
import org.noear.solon.annotation.XServerEndpoint;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.FieldWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.VarGather;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.XBridge;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XEventListener;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XScaner;
import org.noear.solon.core.XUpstreamFactory;
import org.noear.solon.ext.BiConsumerEx;

public class AopContext
extends BeanContainer {
    private boolean _beanLoaded;
    private Set<Runnable> _loadedEvent = new LinkedHashSet<Runnable>();

    public AopContext() {
        this.initialize();
    }

    protected void initialize() {
        this.beanBuilderAdd(XConfiguration.class, (clz, bw, anno) -> {
            XInject typeInj = clz.getAnnotation(XInject.class);
            if (typeInj != null && XUtil.isNotEmpty(typeInj.value()) && typeInj.value().startsWith("${")) {
                XUtil.injectProperties(bw.raw(), XApp.cfg().getPropByExpr(typeInj.value()));
            }
            for (MethodWrap mWrap : ClassWrap.get(bw.clz()).methodWraps) {
                XBean m_an = mWrap.getMethod().getAnnotation(XBean.class);
                if (m_an == null) continue;
                XInject beanInj = mWrap.getMethod().getAnnotation(XInject.class);
                this.tryBuildBean(m_an, mWrap, bw, beanInj, p1 -> {
                    XInject tmp = p1.getAnnotation(XInject.class);
                    if (tmp == null) {
                        return null;
                    }
                    return tmp.value();
                });
            }
            this.addBeanShape(clz, bw);
        });
        this.beanBuilderAdd(XBean.class, (clz, bw, anno) -> {
            BeanWebWrap bww;
            bw.nameSet(anno.value());
            bw.tagSet(anno.tag());
            bw.attrsSet(anno.attrs());
            bw.typedSet(anno.typed());
            this.addBeanShape(clz, bw);
            bw.remotingSet(anno.remoting());
            this.beanRegister(bw, anno.value(), anno.typed());
            if (bw.remoting() && (bww = new BeanWebWrap(bw)).mapping() != null) {
                bww.load(XApp.global());
            }
        });
        this.beanBuilderAdd(XController.class, (clz, bw, anno) -> new BeanWebWrap(bw).load(XApp.global()));
        this.beanBuilderAdd(XInterceptor.class, (clz, bw, anno) -> new BeanWebWrap(bw).main(false).load(XApp.global()));
        this.beanBuilderAdd(XServerEndpoint.class, (clz, wrap, anno) -> {
            if (XListener.class.isAssignableFrom(clz)) {
                XListener l = (XListener)wrap.raw();
                XApp.global().router().add(anno.value(), anno.method(), l);
            }
        });
        this.beanInjectorAdd(XInject.class, (fwT, anno) -> this.beanInject(fwT, anno.value()));
    }

    private void addBeanShape(Class<?> clz, BeanWrap bw) {
        if (XPlugin.class.isAssignableFrom(bw.clz())) {
            XApp.global().plug((XPlugin)bw.raw());
            return;
        }
        if (XEventListener.class.isAssignableFrom(clz)) {
            this.addEventListener(clz, bw);
            return;
        }
        if (XUpstreamFactory.class.isAssignableFrom(clz)) {
            XBridge.upstreamFactorySet((XUpstreamFactory)bw.raw());
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        for (Type t1 : clz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t1 instanceof ParameterizedType) || (pt = (ParameterizedType)t1).getRawType() != XEventListener.class) continue;
            Class et = (Class)pt.getActualTypeArguments()[0];
            XEventBus.subscribe(et, (XEventListener)bw.raw());
            return;
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Map.Entry<String, FieldWrap> kv : clzWrap.fieldAll().entrySet()) {
            Annotation[] annS = kv.getValue().field.getDeclaredAnnotations();
            if (annS.length <= 0) continue;
            VarHolder varH = kv.getValue().holder(obj);
            this.tryInject(varH, annS);
        }
    }

    public void beanScan(Class<?> source) {
        String dir = "";
        if (source.getPackage() != null) {
            dir = source.getPackage().getName().replace('.', '/');
        }
        XScaner.scan(dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = XUtil.loadClass(className.replace("/", "."));
            if (clz != null) {
                this.tryCreateBean(clz);
            }
        });
    }

    public BeanWrap beanMake(Class<?> clz) {
        BeanWrap bw = this.wrap(clz, null);
        this.tryCreateBean(bw);
        this.putWrap(clz, bw);
        return bw;
    }

    protected void tryInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector bi = (BeanInjector)this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.handler(varH, a);
        }
    }

    protected void tryCreateBean(Class<?> clz) {
        this.tryCreateBean0(clz, (c, a) -> {
            BeanWrap bw = this.wrap(clz, null);
            c.handler(clz, bw, a);
            this.putWrap(clz, bw);
        });
    }

    protected void tryCreateBean(BeanWrap bw) {
        this.tryCreateBean0(bw.clz(), (c, a) -> c.handler(bw.clz(), bw, a));
    }

    protected void tryCreateBean0(Class<?> clz, BiConsumerEx<BeanBuilder, Annotation> consumer) {
        Annotation[] annS = clz.getDeclaredAnnotations();
        if (annS.length > 0) {
            try {
                for (Annotation a : annS) {
                    BeanBuilder creator = (BeanBuilder)this.beanBuilders.get(a.annotationType());
                    if (creator == null) continue;
                    consumer.accept(creator, a);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void tryBuildBean(XBean anno, MethodWrap mWrap, BeanWrap bw, XInject beanInj, Function<Parameter, String> injectVal) throws Exception {
        int size2 = mWrap.getParameters().length;
        if (size2 == 0) {
            Object raw = mWrap.doInvoke(bw.raw(), new Object[0]);
            this.tryBuildBean0(anno, beanInj, mWrap.getReturnType(), raw);
        } else {
            VarGather gather = new VarGather(size2, args2 -> {
                try {
                    Object raw = mWrap.doInvoke(bw.raw(), (Object[])args2);
                    this.tryBuildBean0(anno, beanInj, mWrap.getReturnType(), raw);
                }
                catch (Throwable ex) {
                    XEventBus.push(ex);
                }
            });
            for (Parameter p1 : mWrap.getParameters()) {
                VarHolder p2 = gather.add(p1);
                this.beanInject(p2, injectVal.apply(p1));
            }
        }
    }

    protected void tryBuildBean0(XBean anno, XInject beanInj, Class<?> clz, Object raw) {
        if (raw != null) {
            if (beanInj != null && !XUtil.isEmpty(beanInj.value()) && beanInj.value().startsWith("${")) {
                XUtil.injectProperties(raw, XApp.cfg().getPropByExpr(beanInj.value()));
            }
            XEventBus.push(raw);
            BeanWrap m_bw = new BeanWrap(clz, raw);
            m_bw.nameSet(anno.value());
            m_bw.tagSet(anno.tag());
            m_bw.attrsSet(anno.attrs());
            m_bw.typedSet(anno.typed());
            this.beanRegister(m_bw, anno.value(), anno.typed());
            XEventBus.push(m_bw);
        }
    }

    @XNote(value="\u6dfb\u52a0bean\u52a0\u8f7d\u5b8c\u6210\u4e8b\u4ef6")
    public void beanOnloaded(Runnable fun) {
        this._loadedEvent.add(fun);
        if (this._beanLoaded) {
            fun.run();
        }
    }

    public void beanLoaded() {
        this._beanLoaded = true;
        this._loadedEvent.forEach(f -> f.run());
    }
}

