/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;

public class Aop {
    private static AopContext ac = new AopContext();

    public static AopContext context() {
        return ac;
    }

    public static BeanWrap wrap(Class<?> type, Object bean) {
        return ac.wrap(type, bean);
    }

    public static BeanWrap wrapAndPut(Class<?> type) {
        return Aop.wrapAndPut(type, null);
    }

    public static BeanWrap wrapAndPut(Class<?> type, Object bean) {
        BeanWrap wrap = ac.getWrap(type);
        if (wrap == null) {
            wrap = new BeanWrap(type, bean);
            ac.putWrap(type, wrap);
        }
        return wrap;
    }

    public static boolean has(Object nameOrType) {
        return ac.getWrap(nameOrType) != null;
    }

    public static <T> T get(String name) {
        BeanWrap bw = ac.getWrap(name);
        return bw == null ? null : (T)bw.get();
    }

    public static <T> T get(Class<?> type) {
        if (type == null) {
            return null;
        }
        return Aop.wrapAndPut(type).get();
    }

    public static <T> T getOrNull(Class<?> type) {
        BeanWrap bw = ac.getWrap(type);
        return bw == null ? null : (T)bw.get();
    }

    public static void getAsyn(String name, Consumer<BeanWrap> callback) {
        ac.getWrapAsyn(name, callback);
    }

    public static void getAsyn(Class<?> type, Consumer<BeanWrap> callback) {
        ac.getWrapAsyn(type, callback);
    }

    public static <T> T inject(T bean) {
        ac.beanInject(bean);
        return bean;
    }

    public static <T> T inject(T bean, Properties propS) {
        return XUtil.injectProperties(bean, propS);
    }

    public static void beanOnloaded(Runnable fun) {
        ac.beanOnloaded(fun);
    }

    public static void beanForeach(BiConsumer<String, BeanWrap> action) {
        ac.beanForeach(action);
    }

    public static void beanForeach(Consumer<BeanWrap> action) {
        ac.beanForeach(action);
    }
}

