/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XPropertiesLoader;
import org.noear.solon.ext.PrintUtil;

public class ExtendLoader {
    private static final ExtendLoader el = new ExtendLoader();
    private static String path;

    public static String path() {
        return path;
    }

    public static void load(String extend) {
        ExtendLoader.load(extend, false);
    }

    public static void load(String extend, boolean autoMake) {
        if (XUtil.isNotEmpty(extend)) {
            if (extend.startsWith("!")) {
                extend = extend.substring(1);
                autoMake = true;
            }
            if ((extend = XUtil.buildExt(extend, autoMake)) != null) {
                path = extend;
                PrintUtil.blueln("solon.extend: " + path);
                el.loadFile(new File(path));
            }
        }
    }

    public static boolean loadJar(File file) {
        try {
            XClassLoader.global().loadJar(file.toURI().toURL());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean unloadJar(File file) {
        try {
            XClassLoader.global().unloadJar(file.toURI().toURL());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private ExtendLoader() {
    }

    private void loadFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.loadFileDo(tmp);
            }
        } else {
            this.loadFileDo(file);
        }
    }

    private void loadFileDo(File file) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    ExtendLoader.loadJar(file);
                    return;
                }
                if (path.endsWith(".properties")) {
                    XApp.cfg().loadAdd(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
                if (path.endsWith(".yml")) {
                    if (!XPropertiesLoader.global().isSupport(path)) {
                        throw new RuntimeException("Do not support the *.yml");
                    }
                    XApp.cfg().loadAdd(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

