/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.Serializable;
import org.noear.solon.annotation.XNote;

public class XResult<T>
implements Serializable {
    private static final XResult SUCCEED = new XResultReadonly<Object>(null);
    private static final XResult FAILURE = new XResultReadonly(0, "");
    private int code;
    private String description;
    private T data;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public XResult(T data) {
        this.code = 1;
        this.description = "";
        this.data = data;
    }

    public XResult(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @XNote(value="\u6210\u529f\u7684\u7a7a\u7ed3\u679c")
    public static <T> XResult<T> succeed() {
        return SUCCEED;
    }

    @XNote(value="\u6210\u529f\u7684\u7ed3\u679c")
    public static <T> XResult<T> succeed(T data) {
        return new XResult<T>(data);
    }

    @XNote(value="\u5931\u8d25\u7684\u7a7a\u7ed3\u679c")
    public static <T> XResult<T> failure() {
        return FAILURE;
    }

    @XNote(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> XResult<T> failure(int code) {
        return XResult.failure(code, "");
    }

    @XNote(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> XResult<T> failure(int code, String description) {
        return new XResult<T>(code, description);
    }

    @XNote(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> XResult<T> failure(String description) {
        return new XResult<T>(0, description);
    }

    static class XResultReadonly<T>
    extends XResult<T> {
        public XResultReadonly(T data) {
            super(data);
        }

        public XResultReadonly(int code, String description) {
            super(code, description);
        }

        @Override
        public void setCode(int code) {
            throw new RuntimeException("Thes result is readonly!");
        }

        @Override
        public void setData(T data) {
            throw new RuntimeException("Thes result is readonly!");
        }

        @Override
        public void setDescription(String description) {
            throw new RuntimeException("Thes result is readonly!");
        }
    }
}

