/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.XAround;
import org.noear.solon.core.Aop;
import org.noear.solon.core.MethodHolder;
import org.noear.solon.core.XInterceptor;
import org.noear.solon.core.XInterceptorChain;

public class MethodWrap
implements XInterceptorChain,
MethodHolder {
    private static Map<Method, MethodWrap> cached = new HashMap<Method, MethodWrap>();
    private final Class<?> entityClz;
    private final Method method;
    private final Parameter[] parameters;
    private final Annotation[] annotations;
    private final List<XInterceptorChain.Entity> arounds;
    private final XInterceptorChain invokeChain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodWrap get(Method method) {
        MethodWrap mw = cached.get(method);
        if (mw == null) {
            Method method2 = method;
            synchronized (method2) {
                mw = cached.get(method);
                if (mw == null) {
                    mw = new MethodWrap(method);
                    cached.put(method, mw);
                }
            }
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        this.entityClz = m.getDeclaringClass();
        this.method = m;
        this.parameters = m.getParameters();
        this.annotations = m.getAnnotations();
        this.arounds = new ArrayList<XInterceptorChain.Entity>();
        for (Annotation anno : this.entityClz.getAnnotations()) {
            if (anno instanceof XAround) {
                this.doAroundAdd((XAround)anno);
                continue;
            }
            this.doAroundAdd(anno.annotationType().getAnnotation(XAround.class));
        }
        for (Annotation anno : this.annotations) {
            if (anno instanceof XAround) {
                this.doAroundAdd((XAround)anno);
                continue;
            }
            this.doAroundAdd(anno.annotationType().getAnnotation(XAround.class));
        }
        if (this.arounds.size() > 0) {
            this.arounds.sort(Comparator.comparing(x -> x.index));
            XInterceptorChain.Entity node = this.arounds.get(0);
            int len = this.arounds.size();
            for (int i = 1; i < len; ++i) {
                node.next = this.arounds.get(i);
                node = this.arounds.get(i);
            }
            node.next = this;
            this.invokeChain = this.arounds.get(0);
        } else {
            this.invokeChain = this;
        }
    }

    private void doAroundAdd(XAround a) {
        if (a != null) {
            this.arounds.add(new XInterceptorChain.Entity(this, a.index(), (XInterceptor)Aop.get(a.value())));
        }
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.method.getAnnotation(type);
    }

    @Override
    public MethodHolder method() {
        return this;
    }

    @Override
    public Object doIntercept(Object obj, Object[] args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invoke(Object obj, Object[] args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        return this.invokeChain.doIntercept(obj, args);
    }
}

