/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;

public class XProperties
extends Properties {
    public XProperties() {
    }

    public XProperties(Properties defaults) {
        super(defaults);
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDef(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDef(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDef(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDef(key, def, Double::parseDouble);
    }

    private <T> T getOrDef(String key, T def, Function<String, T> convert) {
        String temp = this.get(key);
        if (XUtil.isEmpty(temp)) {
            return def;
        }
        return convert.apply(temp);
    }

    public Object getRaw(String key) {
        return super.get(key);
    }

    public XProperties getProp(String keyStarts) {
        XProperties prop = new XProperties();
        this.findDo(keyStarts, prop::put);
        return prop;
    }

    public XMap getXmap(String keyStarts) {
        XMap map = new XMap();
        this.findDo(keyStarts, map::put);
        return map;
    }

    private void findDo(String keyStarts, BiConsumer<String, String> setFun) {
        String key2 = keyStarts + ".";
        int idx2 = key2.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String keyStr;
            if (k instanceof String && v instanceof String && (keyStr = (String)k).startsWith(key2)) {
                setFun.accept(keyStr.substring(idx2), (String)v);
            }
        }));
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        if (this.defaults != null) {
            this.defaults.forEach(action);
        }
        super.forEach(action);
    }
}

