/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XMapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.DataThrowable;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.PathAnalyzer;
import org.noear.solon.core.XActionUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerAide;
import org.noear.solon.core.XMonitor;

public class XAction
extends XHandlerAide
implements XHandler {
    protected final BeanWrap _bw;
    protected final MethodWrap _mw;
    protected String _produces;
    private String _name;
    private boolean _remoting;
    private PathAnalyzer _pr;
    private List<String> _pks;
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public XAction(BeanWrap bw, Method m, XMapping mp, String path, boolean remoting) {
        this._bw = bw;
        this._mw = MethodWrap.get(m);
        this._remoting = remoting;
        if (mp != null) {
            this._produces = mp.produces();
            this._name = mp.value();
        } else {
            this._name = m.getName();
        }
        if (path != null && path.indexOf("{") >= 0) {
            this._pks = new ArrayList<String>();
            Matcher pm = _pkr.matcher(path);
            while (pm.find()) {
                this._pks.add(pm.group(1));
            }
            if (this._pks.size() > 0) {
                this._pr = new PathAnalyzer(path);
            }
        }
    }

    public String name() {
        return this._name;
    }

    @Override
    public void handle(XContext x) throws Throwable {
        x.remotingSet(this._remoting);
        try {
            if (!XUtil.isEmpty(this._produces)) {
                x.contentType(this._produces);
            }
            this.do_handle(x);
        }
        catch (Throwable ex) {
            x.attrSet("error", ex);
            x.render(ex);
            XMonitor.sendError(x, ex);
        }
    }

    private void do_handle(XContext x) throws Throwable {
        for (XHandler h : this._before) {
            try {
                h.handle(x);
            }
            catch (DataThrowable ex) {
                x.setHandled(true);
                this.renderDo(x, ex);
            }
        }
        if (!x.getHandled()) {
            try {
                Matcher pm;
                if (this._pr != null && (pm = this._pr.matcher(x.path())).find()) {
                    int len = this._pks.size();
                    for (int i = 0; i < len; ++i) {
                        x.paramSet(this._pks.get(i), pm.group(i + 1));
                    }
                }
                this.renderDo(x, this.callDo(this._bw.get(), x));
            }
            catch (DataThrowable ex) {
                this.renderDo(x, ex);
            }
            catch (Throwable ex) {
                x.attrSet("error", ex);
                this.renderDo(x, ex);
                XMonitor.sendError(x, ex);
            }
        }
        for (XHandler h : this._after) {
            h.handle(x);
        }
    }

    protected Object callDo(Object obj, XContext x) throws Throwable {
        return XActionUtil.exeMethod(obj, this._mw, x);
    }

    protected void renderDo(XContext x, Object result) throws Throwable {
        x.render(result);
    }
}

