/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.FieldWrap;
import org.noear.solon.core.PathAnalyzer;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPropertiesLoader;
import org.noear.solon.core.utils.TypeUtil;

public class XUtil {
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public static String guid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !XUtil.isEmpty(s);
    }

    public static <T> T firstOrNull(List<T> list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static Class<?> loadClass(String className) {
        try {
            return XClassLoader.global().loadClass(className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T newClass(String className) {
        try {
            return (T)XUtil.loadClass(className).newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = XClassLoader.global().getResources(name);
        if (urls == null || !urls.hasMoreElements()) {
            urls = ClassLoader.getSystemResources(name);
        }
        return urls;
    }

    public static URL getResource(String name) {
        URL url = XClassLoader.global().getResource(name);
        if (url == null) {
            url = XUtil.class.getResource(name);
        }
        return url;
    }

    public static Properties getProperties(URL url) {
        try {
            return XPropertiesLoader.global.load(url);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties getProperties(String txt) {
        try {
            return XPropertiesLoader.global.load(txt);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getFullStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static String mergePath(String path1, String path2) {
        if (XUtil.isEmpty(path1)) {
            if (path2.startsWith("/")) {
                return path2;
            }
            return "/" + path2;
        }
        if (!path1.startsWith("/")) {
            path1 = "/" + path1;
        }
        if (XUtil.isEmpty(path2)) {
            return path1;
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        if (path1.endsWith("/")) {
            return path1 + path2;
        }
        if (path1.endsWith("*")) {
            int idx = path1.lastIndexOf(47) + 1;
            if (idx < 1) {
                return path2;
            }
            return path1.substring(0, idx) + path2;
        }
        return path1 + "/" + path2;
    }

    public static XMap pathVarMap(String path, String expr) {
        XMap _map = new XMap();
        if (expr.indexOf("{") >= 0) {
            PathAnalyzer _pr;
            String path2 = null;
            try {
                path2 = URLDecoder.decode(path, "utf-8");
            }
            catch (Exception ex) {
                path2 = path;
            }
            Matcher pm = _pkr.matcher(expr);
            ArrayList<String> _pks = new ArrayList<String>();
            while (pm.find()) {
                _pks.add(pm.group(1));
            }
            if (_pks.size() > 0 && (pm = (_pr = new PathAnalyzer(expr)).matcher(path2)).find()) {
                int len = _pks.size();
                for (int i = 0; i < len; ++i) {
                    _map.put((String)_pks.get(i), pm.group(i + 1));
                }
            }
        }
        return _map;
    }

    public static String buildExt(String ext_dir, boolean autoCreate) {
        URL temp = XUtil.getResource("application.properties");
        if (temp == null) {
            temp = XUtil.getResource("application.yml");
        }
        if (temp == null) {
            return null;
        }
        String uri = temp.toString();
        if (uri.startsWith("file:/")) {
            uri = uri.substring(5, uri.length() - 30);
        } else {
            int idx = uri.indexOf("jar!/");
            idx = uri.lastIndexOf("/", idx) + 1;
            uri = uri.substring(9, idx);
        }
        uri = uri + ext_dir + "/";
        File dir = new File(uri);
        if (!dir.exists()) {
            if (autoCreate) {
                dir.mkdir();
            } else {
                return null;
            }
        }
        return uri;
    }

    public static void bindTo(Map<String, String> source, Object target) {
        XUtil.bindTo((String k) -> (String)source.get(k), target);
    }

    public static void bindTo(Properties source, Object target) {
        XUtil.bindTo((String k) -> source.getProperty((String)k), target);
    }

    public static void bindTo(Function<String, String> source, Object target) {
        if (target == null) {
            return;
        }
        ClassWrap cw = ClassWrap.get(target.getClass());
        for (Field f1 : cw.fields) {
            String val = source.apply(f1.getName());
            if (val == null) continue;
            FieldWrap fw = cw.getFieldWrap(f1);
            Object val2 = TypeUtil.changeOfPop(f1.getType(), val);
            fw.setValue(target, val2);
        }
    }
}

