/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Map;
import java.util.Properties;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solon.ext.Act2;
import org.noear.solon.ext.Fun1;

public class XProperties
extends Properties {
    public String get(String key) {
        return this.getProperty(key);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDef(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDef(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDef(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDef(key, def, Double::parseDouble);
    }

    private <T> T getOrDef(String key, T def, Fun1<String, T> convert) {
        String temp = this.get(key);
        if (XUtil.isEmpty(temp)) {
            return def;
        }
        return convert.run(temp);
    }

    public Object getRaw(String key) {
        return super.get(key);
    }

    public XProperties getProp(String key) {
        XProperties prop = new XProperties();
        this.find(key, prop::put);
        return prop;
    }

    public XMap getXmap(String key) {
        XMap map = new XMap();
        this.find(key, map::put);
        return map;
    }

    private void find(String key, Act2<String, String> setFun) {
        String key2 = key + ".";
        int idx2 = key2.length();
        String keyStr = null;
        for (Map.Entry<Object, Object> kv : this.entrySet()) {
            keyStr = kv.getKey().toString();
            if (!keyStr.startsWith(key2)) continue;
            setFun.run(keyStr.substring(idx2), kv.getValue().toString());
        }
    }
}

