/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.Route;
import org.noear.solon.core.RouteTable;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;

public class XRouter {
    private final RouteTable<XHandler>[] _routes_h = new RouteTable[6];
    private final List<XHandler>[] _routes_h_c;
    private final RouteTable<XListener> _routes_l;

    public XRouter() {
        this._routes_h[0] = new RouteTable();
        this._routes_h[1] = new RouteTable();
        this._routes_h[2] = new RouteTable();
        this._routes_h[3] = new RouteTable();
        this._routes_h[4] = new RouteTable();
        this._routes_h[5] = new RouteTable();
        this._routes_h_c = new List[3];
        this._routes_h_c[0] = new ArrayList<XHandler>();
        this._routes_h_c[1] = new ArrayList<XHandler>();
        this._routes_h_c[2] = new ArrayList<XHandler>();
        this._routes_l = new RouteTable();
    }

    public void add(String path, XHandler handler) {
        this.add(path, 1, XMethod.HTTP, handler);
    }

    public void add(String path, int endpoint, XMethod method, XHandler handler) {
        this.add(path, endpoint, method, 0, handler);
    }

    public void add(String path, int endpoint, XMethod method, int index, XHandler handler) {
        Route<XHandler> xl = new Route<XHandler>(path, method, index, handler);
        if (endpoint != 1 && "@@".equals(path)) {
            RouteTable<XHandler> tmp = this._routes_h[endpoint + 3];
            tmp.add(xl);
            tmp.sort(Comparator.comparing(l -> l.index));
            this._routes_h_c[endpoint] = tmp.stream().map(r -> (XHandler)r.target).collect(Collectors.toList());
        } else {
            this._routes_h[endpoint].add(xl);
        }
    }

    public void add(String path, XListener listener) {
        this.add(path, XMethod.ALL, listener);
    }

    public void add(String path, XMethod method, XListener listener) {
        this.add(path, method, 0, listener);
    }

    public void add(String path, XMethod method, int index, XListener listener) {
        this._routes_l.add(new Route<XListener>(path, method, index, listener));
    }

    public void clear() {
        this._routes_h[0].clear();
        this._routes_h[1].clear();
        this._routes_h[2].clear();
        this._routes_h[3].clear();
        this._routes_h[4].clear();
        this._routes_h[5].clear();
    }

    public XHandler matchOne(XContext context, int endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this._routes_h[endpoint].matchOne(path, method);
    }

    public List<XHandler> matchAll(XContext context, int endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this._routes_h[endpoint].matchAll(path, method);
    }

    public XListener matchOne(XSession session) {
        String path = session.path();
        return this._routes_l.matchOne(path, session.method());
    }

    public List<XHandler> atBefore() {
        return Collections.unmodifiableList(this._routes_h_c[0]);
    }

    public List<XHandler> atAfter() {
        return Collections.unmodifiableList(this._routes_h_c[2]);
    }
}

