/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class XClassLoader
extends URLClassLoader {
    private static XClassLoader _global = new XClassLoader();
    private Map<URL, JarURLConnection> cachedMap = new HashMap<URL, JarURLConnection>();

    public static XClassLoader global() {
        return _global;
    }

    public XClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public XClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public XClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void loadJar(URL file) {
        try {
            URLConnection uc = file.openConnection();
            if (uc instanceof JarURLConnection) {
                JarURLConnection juc = (JarURLConnection)uc;
                juc.setUseCaches(true);
                juc.getManifest();
                this.cachedMap.put(file, juc);
            }
        }
        catch (Throwable ex) {
            System.err.println("Failed to cache plugin JAR file: " + file.toExternalForm());
        }
        this.addURL(file);
    }

    public void unloadJar(URL file) {
        JarURLConnection jarURL = this.cachedMap.get(file);
        if (jarURL == null) {
            return;
        }
        try {
            jarURL.getJarFile().close();
            jarURL = null;
            this.cachedMap.remove(file);
            System.gc();
        }
        catch (Throwable ex) {
            System.err.println("Failed to unload JAR file\n" + ex);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    public static void bindingThread() {
        Thread.currentThread().setContextClassLoader(XClassLoader.global());
    }
}

