/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Properties;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.annotation.XController;
import org.noear.solon.annotation.XInject;
import org.noear.solon.annotation.XInterceptor;
import org.noear.solon.core.Aop;
import org.noear.solon.core.AopFactoryBase;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.FieldWrapTmp;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XScaner;
import org.noear.solon.core.utils.TypeUtil;

public class AopFactory
extends AopFactoryBase {
    public AopFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.beanCreatorAdd(XConfiguration.class, (clz, bw, anno) -> {
            for (MethodWrap mWrap : ClassWrap.get(bw.clz()).methodWraps) {
                XBean m_an = mWrap.method.getAnnotation(XBean.class);
                if (m_an == null) continue;
                if (mWrap.parameters.length == 0) {
                    Object raw = mWrap.method.invoke(bw.raw(), new Object[0]);
                    BeanWrap m_bw = Aop.put(mWrap.method.getReturnType(), raw);
                    this.beanCreate(m_bw, m_an);
                    continue;
                }
                throw new RuntimeException("XBean method does not support parameters");
            }
        });
        this.beanCreatorAdd(XBean.class, (clz, bw, anno) -> this.beanCreate(bw, (XBean)anno));
        this.beanCreatorAdd(XController.class, (clz, bw, anno) -> new BeanWebWrap(bw).load(XApp.global()));
        this.beanCreatorAdd(XInterceptor.class, (clz, bw, anno) -> {
            BeanWebWrap bww = new BeanWebWrap(bw);
            bww.endpointSet(anno.after() ? 2 : 0);
            bww.load(XApp.global());
        });
        this.defaultInjector = (fwT, anno) -> {
            if (XUtil.isEmpty(anno.value())) {
                Aop.getAsyn(fwT.getType(), fwT, bw -> fwT.setValue(bw.get()));
            } else if (Properties.class == fwT.getType()) {
                Properties val = XApp.cfg().getProp(anno.value());
                fwT.setValue(val);
            } else {
                Object tmp = Aop.get(anno.value());
                if (tmp != null) {
                    fwT.setValue(tmp);
                } else {
                    String val = XApp.cfg().get(anno.value());
                    if (!XUtil.isEmpty(val)) {
                        Object val2 = TypeUtil.changeOfPop(fwT.getType(), val);
                        fwT.setValue(val2);
                    } else {
                        Aop.getAsyn(anno.value(), bw -> fwT.setValue(bw.get()));
                    }
                }
            }
        };
    }

    protected void beanCreate(BeanWrap bw, XBean anno) {
        bw._remoting = anno.remoting();
        if (XPlugin.class.isAssignableFrom(bw.clz())) {
            XApp.global().plug((XPlugin)bw.raw());
        } else {
            Class<?>[] list;
            if (!XUtil.isEmpty(anno.value())) {
                Aop.put(anno.value(), bw);
            } else {
                Aop.put(bw.clz().getName(), bw);
            }
            if (anno.remoting()) {
                BeanWebWrap bww = new BeanWebWrap(bw);
                bww.remotingSet(true);
                bww.load(XApp.global());
            }
            for (Class<?> c : list = bw.clz().getInterfaces()) {
                if (c.getName().contains("java.")) continue;
                this.clzMapping.put(c, bw.clz());
                this.beanNotice(c, bw);
            }
        }
    }

    @Override
    public BeanWrap wrap(Class<?> clz, Object raw) {
        BeanWrap bw = (BeanWrap)this.beanWraps.get(clz);
        if (bw == null && this.clzMapping.containsKey(clz)) {
            clz = (Class)this.clzMapping.get(clz);
            bw = (BeanWrap)this.beanWraps.get(clz);
        }
        if (bw == null) {
            if (clz.isInterface() && raw == null) {
                return null;
            }
            bw = new BeanWrap(clz, raw);
            this.beanWraps.putIfAbsent(clz, bw);
        }
        return bw;
    }

    public void inject(Object obj) {
        Field[] fs;
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Field f : fs = clzWrap.fields) {
            XInject xi = f.getAnnotation(XInject.class);
            if (xi == null) continue;
            FieldWrapTmp fwT = clzWrap.getFieldWrap(f).tmp(obj);
            this.tryBeanInject(fwT, xi);
        }
    }

    public void put(String key, BeanWrap wrap) {
        if (!XUtil.isEmpty(key) && !this.beans.containsKey(key)) {
            this.beans.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public BeanWrap get(String key) {
        return (BeanWrap)this.beans.get(key);
    }

    public void beanLoad(Class<?> source) {
        String dir = "";
        if (source.getPackage() != null) {
            dir = source.getPackage().getName().replace('.', '/');
        }
        ArrayList tmpList = new ArrayList();
        XScaner.scan(dir, n -> n.endsWith(".class")).stream().map(name -> {
            String className = name.substring(0, name.length() - 6);
            return XUtil.loadClass(className.replace("/", "."));
        }).forEach(clz -> {
            Annotation[] annoSet;
            if (clz != null && (annoSet = clz.getDeclaredAnnotations()).length > 0) {
                try {
                    this.tryCreateBean((Class<?>)clz, annoSet);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.loadedEvent.forEach(f -> f.run());
    }
}

