/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.XAppProperties;
import org.noear.solon.XRouter;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XNote;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.XBridge;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XContextUtil;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XEventListener;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerSlots;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XRouterHandler;
import org.noear.solon.ext.ConsumerEx;
import org.noear.solon.ext.PrintUtil;

public class XApp
implements XHandler,
XHandlerSlots {
    private static XApp _global;
    private static boolean _stopped;
    private final Set<BiConsumer<String, Object>> _onSharedAdd_event = new HashSet<BiConsumer<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private final XRouter _router;
    private final int _port;
    private final XAppProperties _prop;
    private final Class<?> _source;
    private XHandler _handler = null;
    private boolean _enableHttp = true;
    private boolean _enableWebSocket = true;
    private boolean _enableSocket = true;
    private boolean _enableTransaction = true;
    private boolean _enableCaching = true;
    private boolean _enableStaticfiles = true;

    @XNote(value="\u5168\u5c40\u5b9e\u4f8b")
    public static XApp global() {
        return _global;
    }

    @XNote(value="\u5e94\u7528\u914d\u7f6e")
    public static XAppProperties cfg() {
        return XApp.global().prop();
    }

    public static XApp start(Class<?> source, String[] args) {
        return XApp.start(source, args, null);
    }

    public static XApp start(Class<?> source, String[] args, ConsumerEx<XApp> builder) {
        XMap argx = XMap.from(args);
        return XApp.start(source, argx, builder);
    }

    public static XApp start(Class<?> source, XMap argx, ConsumerEx<XApp> builder) {
        if (_global != null) {
            return _global;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> XApp.stop(false, 0L)));
        XClassLoader.bindingThread();
        long time_start = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: Start loading");
        _global = new XApp(source, argx);
        String _extend = (String)argx.get("extend");
        if (XUtil.isEmpty(_extend)) {
            _extend = _global.prop().get("solon.extend");
        }
        ExtendLoader.load(_extend);
        _global.prop().plugsScan();
        if (builder != null) {
            try {
                builder.accept(_global);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        List<XPluginEntity> plugs = _global.prop().plugs();
        int len = plugs.size();
        for (int i = 0; i < len; ++i) {
            plugs.get(i).start();
        }
        if (source != null) {
            Aop.factory().beanLoad(source, true);
        }
        XMap map = _global.prop().getXmap("solon.view.mapping");
        map.forEach((k, v) -> XBridge.renderMapping("." + k, v));
        long time_end = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: End loading @" + (time_end - time_start) + "ms");
        return _global;
    }

    public static void stop() {
        XApp.stop(true, 0L);
    }

    public static void stop(boolean exit, long delay) {
        if (_global == null) {
            return;
        }
        _stopped = true;
        XUtil.commonPool.submit(() -> {
            if (delay > 0L) {
                Thread.sleep(delay);
            }
            _global.prop().plugs().forEach(p -> p.stop());
            _global = null;
            if (exit) {
                System.exit(0);
            }
            return null;
        });
    }

    @XNote(value="\u6839\u636e\u6e90\u52a0\u8f7dbean")
    public void loadBean(Class<?> source) {
        Aop.beanLoad(source);
    }

    @XNote(value="\u6839\u636e\u7c7b\u578b\u6784\u5236bean")
    public void makeBean(Class<?> clz) {
        Aop.beanMake(clz);
    }

    @XNote(value="\u6dfb\u52a0\u5171\u4eab\u5bf9\u8c61")
    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.accept(key, obj));
    }

    @XNote(value="\u83b7\u53d6\u5171\u4eab\u5bf9\u8c61\uff08\u5f02\u6b65\u83b7\u53d6\uff09")
    public <T> void sharedGet(String key, Consumer<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.accept(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.accept(v);
                }
            });
        }
    }

    @XNote(value="\u5171\u4eab\u5bf9\u8c61\u6dfb\u52a0\u4e8b\u4ef6")
    public void onSharedAdd(BiConsumer<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    @XNote(value="\u5171\u4eab\u5bf9\u8c61")
    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    @XNote(value="\u8def\u7531\u5668")
    public XRouter router() {
        return this._router;
    }

    protected XApp(Class<?> source, XMap args) {
        this._source = source;
        this._prop = new XAppProperties().load(args);
        this._port = this._prop.serverPort();
        this._router = new XRouter();
        this._handler = new XRouterHandler(this._router);
    }

    @XNote(value="\u5e94\u7528\u52a0\u8f7d\u6e90")
    public Class<?> source() {
        return this._source;
    }

    @XNote(value="\u7aef\u53e3")
    public int port() {
        return this._port;
    }

    @XNote(value="\u5e94\u7528\u5c5e\u6027")
    public XAppProperties prop() {
        return this._prop;
    }

    @XNote(value="\u63d2\u5165\u63d2\u4ef6")
    public void plug(XPlugin plugin) {
        XPluginEntity p = new XPluginEntity(plugin);
        p.start();
        this.prop().plugs().add(p);
    }

    public void before(String expr, XHandler handler) {
        this.before(expr, XMethod.ALL, handler);
    }

    public void before(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 0, method, handler);
    }

    @Override
    public void before(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, 0, method, index, handler);
    }

    public void after(String expr, XHandler handler) {
        this.after(expr, XMethod.ALL, handler);
    }

    public void after(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 2, method, handler);
    }

    @Override
    public void after(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, 2, method, index, handler);
    }

    @Override
    public void add(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 1, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new BeanWebWrap(bw, expr).load(this);
        }
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new BeanWebWrap(bw, expr, remoting).load(this);
        }
    }

    public void all(String path, XHandler handler) {
        this.add(path, XMethod.ALL, handler);
    }

    public void http(String path, XHandler handler) {
        this.add(path, XMethod.HTTP, handler);
    }

    public void get(String path, XHandler handler) {
        this.add(path, XMethod.GET, handler);
    }

    public void post(String path, XHandler handler) {
        this.add(path, XMethod.POST, handler);
    }

    public void put(String path, XHandler handler) {
        this.add(path, XMethod.PUT, handler);
    }

    public void patch(String path, XHandler handler) {
        this.add(path, XMethod.PATCH, handler);
    }

    public void delete(String path, XHandler handler) {
        this.add(path, XMethod.DELETE, handler);
    }

    public void ws(String path, XHandler handler) {
        this.add(path, XMethod.WEBSOCKET, handler);
    }

    public void socket(String path, XHandler handler) {
        this.add(path, XMethod.SOCKET, handler);
    }

    public XHandler handlerGet() {
        return this._handler;
    }

    public void handlerSet(XHandler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    @Override
    public void handle(XContext x) throws Throwable {
        if (_stopped) {
            return;
        }
        try {
            XContextUtil.currentSet(x);
            this._handler.handle(x);
        }
        catch (Throwable ex) {
            XEventBus.push(ex);
            throw ex;
        }
        finally {
            XContextUtil.currentRemove();
        }
    }

    public void tryHandle(XContext x) {
        try {
            this.handle(x);
        }
        catch (Throwable ex) {
            ex = XUtil.throwableUnwrap(ex);
            x.statusSet(500);
            x.setHandled(true);
            x.output(XUtil.getFullStackTrace(ex));
        }
    }

    public XApp onError(XEventListener<Throwable> handler) {
        XEventBus.subscribe(Throwable.class, handler);
        return this;
    }

    public <T> XApp onEvent(Class<T> type, XEventListener<T> handler) {
        XEventBus.subscribe(type, handler);
        return this;
    }

    public boolean enableHttp() {
        return this._enableHttp;
    }

    public XApp enableHttp(boolean enable) {
        this._enableHttp = enable;
        return this;
    }

    public boolean enableWebSocket() {
        return this._enableWebSocket;
    }

    public XApp enableWebSocket(boolean enable) {
        this._enableWebSocket = enable;
        return this;
    }

    public boolean enableSocket() {
        return this._enableSocket;
    }

    public XApp enableSocket(boolean enable) {
        this._enableSocket = enable;
        return this;
    }

    public boolean enableTransaction() {
        return this._enableTransaction;
    }

    public XApp enableTransaction(boolean enable) {
        this._enableTransaction = enable;
        return this;
    }

    public boolean enableCaching() {
        return this._enableCaching;
    }

    public XApp enableCaching(boolean enable) {
        this._enableCaching = enable;
        return this;
    }

    public boolean enableStaticfiles() {
        return this._enableStaticfiles;
    }

    public XApp enableStaticfiles(boolean enable) {
        this._enableStaticfiles = enable;
        return this;
    }
}

