/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.annotation.XController;
import org.noear.solon.annotation.XInject;
import org.noear.solon.annotation.XInterceptor;
import org.noear.solon.core.Aop;
import org.noear.solon.core.AopFactoryBase;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.FieldWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XEventListener;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XScaner;

public class AopFactory
extends AopFactoryBase {
    public AopFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.beanCreatorAdd(XConfiguration.class, (clz, bw, anno) -> {
            XInject typeInj = clz.getAnnotation(XInject.class);
            if (typeInj != null && XUtil.isNotEmpty(typeInj.value()) && typeInj.value().startsWith("${")) {
                Aop.inject(bw.raw(), XApp.cfg().getPropByExpr(typeInj.value()));
            }
            for (MethodWrap mWrap : ClassWrap.get(bw.clz()).methodWraps) {
                XBean m_an = mWrap.getMethod().getAnnotation(XBean.class);
                if (m_an == null) continue;
                XInject beanInj = mWrap.getMethod().getAnnotation(XInject.class);
                this.tryBuildBean(m_an, mWrap, bw, beanInj, p1 -> {
                    XInject tmp = p1.getAnnotation(XInject.class);
                    if (tmp == null) {
                        return null;
                    }
                    return tmp.value();
                });
            }
            if (XPlugin.class.isAssignableFrom(bw.clz())) {
                XApp.global().plug((XPlugin)bw.raw());
                return;
            }
            if (XEventListener.class.isAssignableFrom(clz)) {
                this.addEventListener(clz, bw);
                return;
            }
        });
        this.beanCreatorAdd(XBean.class, (clz, bw, anno) -> {
            BeanWebWrap bww;
            bw.nameSet(anno.value());
            bw.tagSet(anno.tag());
            bw.attrsSet(anno.attrs());
            bw.typedSet(anno.typed());
            if (XPlugin.class.isAssignableFrom(bw.clz())) {
                XApp.global().plug((XPlugin)bw.raw());
                return;
            }
            if (XEventListener.class.isAssignableFrom(clz)) {
                this.addEventListener(clz, bw);
                return;
            }
            bw.remotingSet(anno.remoting());
            this.beanRegister(bw, anno.value(), anno.typed());
            if (bw.remoting() && (bww = new BeanWebWrap(bw)).mapping() != null) {
                bww.load(XApp.global());
            }
        });
        this.beanCreatorAdd(XController.class, (clz, bw, anno) -> new BeanWebWrap(bw).load(XApp.global()));
        this.beanCreatorAdd(XInterceptor.class, (clz, bw, anno) -> new BeanWebWrap(bw).main(false).load(XApp.global()));
        this.beanInjectorAdd(XInject.class, (fwT, anno) -> this.tryInjectByName(fwT, anno.value()));
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        for (Type t1 : clz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t1 instanceof ParameterizedType) || (pt = (ParameterizedType)t1).getRawType() != XEventListener.class) continue;
            Class et = (Class)pt.getActualTypeArguments()[0];
            XEventBus.subscribe(et, (XEventListener)bw.raw());
            return;
        }
    }

    public void beanLoad(Class<?> source, boolean loaded) {
        String dir = "";
        if (source.getPackage() != null) {
            dir = source.getPackage().getName().replace('.', '/');
        }
        XScaner.scan(dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = XUtil.loadClass(className.replace("/", "."));
            if (clz != null) {
                this.tryCreateBean(clz);
            }
        });
        if (loaded) {
            this.loadedEvent.forEach(f -> f.run());
        }
    }

    public BeanWrap beanMake(Class<?> clz) {
        BeanWrap bw = this.wrap(clz, null);
        this.tryCreateBean(bw);
        this.putWrap(clz, bw);
        return bw;
    }

    public void beanRegister(BeanWrap bw, String name, boolean typed) {
        Class<?>[] list;
        if (XUtil.isNotEmpty(name)) {
            Aop.factory().putWrap(name, bw);
            if (!typed) {
                return;
            }
        }
        Aop.factory().putWrap(bw.clz(), bw);
        Aop.factory().putWrap(bw.clz().getName(), bw);
        for (Class<?> c : list = bw.clz().getInterfaces()) {
            if (c.getName().contains("java.")) continue;
            this.clzMapping.putIfAbsent(c, bw.clz());
            Aop.factory().putWrap(c, bw);
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Map.Entry<String, FieldWrap> kv : clzWrap.fieldAll().entrySet()) {
            Annotation[] annS = kv.getValue().field.getDeclaredAnnotations();
            if (annS.length <= 0) continue;
            VarHolder varH = kv.getValue().holder(obj);
            this.tryInject(varH, annS);
        }
    }
}

