/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XPropertiesLoader;
import org.noear.solon.ext.PrintUtil;

public class ExtendLoader {
    private static final ExtendLoader _g = new ExtendLoader();
    private Method addURL;
    private URLClassLoader urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();

    public static void load(String path) {
        if (!XUtil.isEmpty(path)) {
            if (path.indexOf("/") < 0) {
                path = XUtil.buildExt(path, false);
            }
            if (path != null) {
                PrintUtil.blueln("solon.extend: " + path);
                File file = new File(path);
                _g.do_load(file);
            }
        }
    }

    public static void loadJar(File file) {
        _g.do_loadFile(file);
    }

    private ExtendLoader() {
        try {
            this.addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            this.addURL.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void do_load(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.do_loadFile(tmp);
            }
        } else {
            this.do_loadFile(file);
        }
    }

    private void do_loadFile(File file) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    this.addURL.invoke((Object)this.urlLoader, file.toURI().toURL());
                    return;
                }
                if (path.endsWith(".properties")) {
                    XApp.global().prop().load(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
                if (path.endsWith(".yml")) {
                    if (!XPropertiesLoader.global.isSupport(path)) {
                        throw new RuntimeException("Do not support the *.yml");
                    }
                    XApp.global().prop().load(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

