/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.annotation.XController;
import org.noear.solon.annotation.XInject;
import org.noear.solon.annotation.XInterceptor;
import org.noear.solon.core.Aop;
import org.noear.solon.core.AopFactoryBase;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanLoader;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XScaner;
import org.noear.solon.core.utils.TypeUtil;

public class AopFactory
extends AopFactoryBase {
    public AopFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.beanLoaderAdd(XBean.class, (clz, bw, anno) -> this.loadXBean(bw, (XBean)anno));
        this.beanLoaderAdd(XConfiguration.class, (clz, bw, anno) -> {
            for (MethodWrap mWrap : ClassWrap.get(bw.clz()).methodWraps) {
                XBean m_an = mWrap.method.getAnnotation(XBean.class);
                if (m_an == null || mWrap.parameters.length != 0) continue;
                Object raw = mWrap.method.invoke(bw.raw(), new Object[0]);
                BeanWrap m_bw = Aop.put(mWrap.method.getReturnType(), raw);
                this.loadXBean(m_bw, m_an);
            }
        });
        this.beanLoaderAdd(XController.class, (clz, bw, anno) -> new BeanWebWrap(bw).load(XApp.global()));
        this.beanLoaderAdd(XInterceptor.class, (clz, bw, anno) -> {
            BeanWebWrap bww = new BeanWebWrap(bw);
            bww.endpointSet(anno.after() ? 2 : 0);
            bww.load(XApp.global());
        });
    }

    protected void loadXBean(BeanWrap bw, XBean anno) {
        bw._remoting = anno.remoting();
        if (XPlugin.class.isAssignableFrom(bw.clz())) {
            XApp.global().plug((XPlugin)bw.raw());
        } else {
            Class<?>[] list;
            if (!XUtil.isEmpty(anno.value())) {
                Aop.put(anno.value(), bw);
            } else {
                Aop.put(bw.clz().getName(), bw);
            }
            if (anno.remoting()) {
                BeanWebWrap bww = new BeanWebWrap(bw);
                bww.remotingSet(true);
                bww.load(XApp.global());
            }
            for (Class<?> c : list = bw.clz().getInterfaces()) {
                if (c.getName().contains("java.")) continue;
                this.clzMapping.put(c, bw.clz());
                this.beanNotice(c, bw);
            }
        }
    }

    public BeanWrap wrap(Class<?> clz, Object raw) {
        BeanWrap bw = (BeanWrap)this.beanWraps.get(clz);
        if (bw == null && this.clzMapping.containsKey(clz)) {
            clz = (Class)this.clzMapping.get(clz);
            bw = (BeanWrap)this.beanWraps.get(clz);
        }
        if (bw == null) {
            if (clz.isInterface() && raw == null) {
                return null;
            }
            bw = new BeanWrap().build(clz, raw);
            this.beanWraps.putIfAbsent(clz, bw);
        }
        return bw;
    }

    public void inject(Object obj) {
        Field[] fs;
        if (obj == null) {
            return;
        }
        for (Field f : fs = ClassWrap.get(obj.getClass()).fields) {
            Object val;
            XInject xi = f.getAnnotation(XInject.class);
            if (xi == null) continue;
            if (XUtil.isEmpty(xi.value())) {
                Aop.getAsyn(f.getType(), f.getAnnotations(), bw -> AopFactory.fieldSet(obj, f, bw.get()));
                continue;
            }
            if (Properties.class == f.getType()) {
                val = XApp.cfg().getProp(xi.value());
                AopFactory.fieldSet(obj, f, val);
                continue;
            }
            val = XApp.cfg().get(xi.value());
            if (!XUtil.isEmpty((String)val)) {
                Object val2 = TypeUtil.changeOfPop(f.getType(), (String)val);
                AopFactory.fieldSet(obj, f, val2);
                continue;
            }
            Aop.getAsyn(xi.value(), bw -> AopFactory.fieldSet(obj, f, bw.get()));
        }
    }

    protected Object tryBuildBean(Class<?> clz, Annotation[] fAnnoS) {
        BeanBuilder bb;
        Object tmp = null;
        Iterator iterator = this.beanBuilders.iterator();
        while (iterator.hasNext() && (tmp = (bb = (BeanBuilder)iterator.next()).build(clz, fAnnoS)) == null) {
        }
        return tmp;
    }

    protected static void fieldSet(Object obj, Field f, Object val) {
        try {
            f.setAccessible(true);
            f.set(obj, val);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void put(String key, BeanWrap wrap) {
        if (!XUtil.isEmpty(key) && !this.beans.containsKey(key)) {
            this.beans.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public BeanWrap get(String key) {
        return (BeanWrap)this.beans.get(key);
    }

    public <T extends Annotation> void beanLoaderAdd(Class<T> anno, BeanLoader<T> loader) {
        this.beanLoaders.put(anno, loader);
    }

    public void beanBuilderAdd(BeanBuilder builder) {
        this.beanBuilders.add(builder);
    }

    public void beanLoad(Class<?> source) {
        String dir = source.getPackage().getName().replace('.', '/');
        ArrayList tmpList = new ArrayList();
        XScaner.scan(dir, n -> n.endsWith(".class")).stream().map(name -> {
            String className = name.substring(0, name.length() - 6);
            return XUtil.loadClass(className.replace("/", "."));
        }).forEach(clz -> {
            Annotation[] annoSet;
            if (clz != null && (annoSet = clz.getDeclaredAnnotations()).length > 0) {
                this.tryLoadClasses((Class<?>)clz, annoSet);
            }
        });
        this.loadedEvent.forEach(f -> f.run());
    }

    protected boolean tryLoadClasses(Class<?> clz, Annotation[] annoSet) {
        for (Annotation a : annoSet) {
            BeanLoader loader = (BeanLoader)this.beanLoaders.get(a.annotationType());
            if (loader == null) continue;
            this.tryLoadAnno(clz, a, loader);
            return true;
        }
        return false;
    }

    protected <T extends Annotation> void tryLoadAnno(Class<?> clz, T anno, BeanLoader<T> loader) {
        try {
            BeanWrap wrap = this.wrap(clz, null);
            loader.handler(clz, wrap, anno);
            this.beanNotice(clz, wrap);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

