/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.XProperties;
import org.noear.solon.XRouter;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XContextUtil;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XMonitor;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XRouterHandler;
import org.noear.solon.ext.Act1;
import org.noear.solon.ext.Act2;
import org.noear.solon.ext.PrintUtil;

public class XApp
implements XHandler {
    private static XApp _global;
    private final Set<Act2<String, Object>> _onSharedAdd_event = new HashSet<Act2<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private final XRouter _router;
    private final int _port;
    private final XProperties _prop;
    private XHandler _handler = null;

    public static XApp global() {
        return _global;
    }

    public static XApp start(Class<?> source, String[] args) {
        return XApp.start(source, args, null);
    }

    public static XApp start(Class<?> source, String[] args, Act1<XApp> builder) {
        XMap argx = XMap.from(args);
        return XApp.start(source, argx, builder);
    }

    public static XApp start(Class<?> source, XMap argx, Act1<XApp> builder) {
        if (_global != null) {
            return _global;
        }
        long time_start = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: Start loading");
        _global = new XApp(argx);
        String _extend = (String)argx.get("extend");
        if (XUtil.isEmpty(_extend)) {
            _extend = _global.prop().get("solon.extend");
        }
        ExtendLoader.load(_extend);
        _global.prop().plugsScan();
        if (builder != null) {
            builder.run(_global);
        }
        List<XPluginEntity> plugs = _global.prop().plugs();
        int len = plugs.size();
        for (int i = 0; i < len; ++i) {
            plugs.get(i).start();
        }
        if (source != null) {
            _global.loadBean(source);
        }
        XMap map = _global.prop().getXmap("solon.view.mapping");
        map.forEach((k, v) -> XRenderManager.mapping("." + k, v));
        long time_end = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: End loading @" + (time_end - time_start) + "ms");
        return _global;
    }

    public static void stop() {
        if (_global == null) {
            return;
        }
        _global.prop().plugs().forEach(p -> p.stop());
    }

    public void loadBean(Class<?> source) {
        Aop.beanLoad(source);
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.run(key, obj));
    }

    public <T> void sharedGet(String key, Act1<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.run(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.run(v);
                }
            });
        }
    }

    public void onSharedAdd(Act2<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    public XRouter router() {
        return this._router;
    }

    protected XApp(XMap args) {
        this._prop = new XProperties().load(args);
        this._port = this._prop.serverPort();
        this._router = new XRouter();
        this._handler = new XRouterHandler(this._router);
    }

    public int port() {
        return this._port;
    }

    public XProperties prop() {
        return this._prop;
    }

    public void plug(XPlugin plugin) {
        XPluginEntity p = new XPluginEntity(plugin);
        p.start();
        this.prop().plugs().add(p);
    }

    public void before(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 0, method, handler);
    }

    public void before(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, 0, method, index, handler);
    }

    public void after(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 2, method, handler);
    }

    public void after(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, 2, method, index, handler);
    }

    public void add(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 1, method, handler);
    }

    public void all(String path, XHandler handler) {
        this.add(path, XMethod.HTTP, handler);
    }

    public void get(String path, XHandler handler) {
        this.add(path, XMethod.GET, handler);
    }

    public void post(String path, XHandler handler) {
        this.add(path, XMethod.POST, handler);
    }

    public void put(String path, XHandler handler) {
        this.add(path, XMethod.PUT, handler);
    }

    public void patch(String path, XHandler handler) {
        this.add(path, XMethod.PATCH, handler);
    }

    public void delete(String path, XHandler handler) {
        this.add(path, XMethod.DELETE, handler);
    }

    public void send(String path, XHandler handler) {
        this.add(path, XMethod.SEND, handler);
    }

    public XHandler handlerGet() {
        return this._handler;
    }

    public void handlerSet(XHandler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    @Override
    public void handle(XContext x) throws Throwable {
        try {
            XContextUtil.currentSet(x);
            this._handler.handle(x);
        }
        catch (Throwable ex) {
            XMonitor.sendError(x, ex);
            throw ex;
        }
        finally {
            XContextUtil.currentRemove();
        }
    }

    public XApp onError(Act2<XContext, Throwable> event) {
        XMonitor.onError(event);
        return this;
    }
}

