/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;

public class ExtendLoader {
    private static final ExtendLoader _g = new ExtendLoader();
    private Method addURL;
    private URLClassLoader urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();

    public static void load(String path, XMap map) {
        if (!XUtil.isEmpty(path)) {
            File file = new File(path);
            _g.do_load(file, map);
        }
    }

    public static void loadJar(File file) {
        _g.do_loadFile(file, null);
    }

    private ExtendLoader() {
        try {
            this.addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            this.addURL.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void do_load(File file, XMap map) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.do_loadFile(tmp, map);
            }
        } else {
            this.do_loadFile(file, map);
        }
    }

    private void do_loadFile(File file, XMap map) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    this.addURL.invoke((Object)this.urlLoader, file.toURI().toURL());
                    return;
                }
                if (map != null && path.endsWith(".properties")) {
                    Properties prop = new Properties();
                    prop.load(file.toURI().toURL().openStream());
                    prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString().trim())));
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

