/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.PrintUtil;

public class XRenderManager
implements XRender {
    public static final String mapping_model = "model";
    private static final Map<String, XRender> _mapping = new HashMap<String, XRender>();
    private static final Map<String, XRender> _lib = new HashMap<String, XRender>();
    private static XRender _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };
    public static XRenderManager global = new XRenderManager();

    private XRenderManager() {
        XRenderManager.mapping(mapping_model, _def);
    }

    public static void register(XRender render) {
        _def = render;
        _lib.put(render.getClass().getSimpleName(), render);
        PrintUtil.blueln("solon:: view load:" + render.getClass().getSimpleName());
    }

    public static void mapping(String suffix, XRender render) {
        _mapping.put(suffix, render);
        PrintUtil.blueln("solon:: view load:" + render.getClass().getSimpleName());
    }

    public static void mapping(String suffix, String classSimpleName) {
        XRender render = _lib.get(classSimpleName);
        if (render == null) {
            PrintUtil.redln("solon:: " + classSimpleName + " not exists!");
            return;
        }
        _mapping.put(suffix, render);
    }

    @Override
    public void render(Object obj, XContext ctx) throws Throwable {
        ModelAndView mv;
        if (obj instanceof ModelAndView && !XUtil.isEmpty((mv = (ModelAndView)obj).view())) {
            String suffix;
            XRender render;
            int suffix_idx = mv.view().lastIndexOf(".");
            if (suffix_idx > 0 && (render = _mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                render.render(mv, ctx);
                return;
            }
            _def.render(mv, ctx);
            return;
        }
        _mapping.get(mapping_model).render(obj, ctx);
    }
}

