/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XInject;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanCreator;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanSubscriber;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.VarHolderParam;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XProperties;
import org.noear.solon.core.utils.TypeUtil;

public abstract class AopFactoryBase {
    protected final Map<Class<?>, BeanWrap> beanWraps = new ConcurrentHashMap();
    protected final Map<String, BeanWrap> beans = new ConcurrentHashMap<String, BeanWrap>();
    protected final Map<Class<?>, Class<?>> clzMapping = new ConcurrentHashMap();
    protected final Map<Class<?>, BeanCreator<?>> beanCreators = new HashMap();
    protected final Map<Class<?>, BeanInjector<?>> beanInjectors = new HashMap();
    protected final Set<Runnable> loadedEvent = new LinkedHashSet<Runnable>();
    protected final Set<BeanSubscriber> subSet = new LinkedHashSet<BeanSubscriber>();

    public <T extends Annotation> void beanCreatorAdd(Class<T> anno, BeanCreator<T> creater) {
        this.beanCreators.put(anno, creater);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> anno, BeanInjector<T> injector) {
        this.beanInjectors.put(anno, injector);
    }

    public void beanSubscribe(Object key, Consumer<BeanWrap> callback) {
        if (key != null) {
            this.subSet.add(new BeanSubscriber(key, callback));
        }
    }

    public void beanNotice(Object key, BeanWrap wrap) {
        if (wrap.raw() == null) {
            return;
        }
        new ArrayList<BeanSubscriber>(this.subSet).forEach(s1 -> {
            if (s1.key.equals(key)) {
                s1.callback.accept(wrap);
            }
        });
    }

    public void putWrap(String key, BeanWrap wrap) {
        if (!XUtil.isEmpty(key) && wrap.raw() != null && !this.beans.containsKey(key)) {
            this.beans.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public void putWrap(Class<?> key, BeanWrap wrap) {
        if (key != null && wrap.raw() != null && !this.beanWraps.containsKey(key)) {
            this.beanWraps.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public BeanWrap getWrap(Object key) {
        if (key instanceof String) {
            return this.beans.get(key);
        }
        if (key instanceof Class) {
            return this.beanWraps.get(key);
        }
        return null;
    }

    public BeanWrap wrap(Class<?> clz, Object bean) {
        BeanWrap wrap = this.getWrap(clz);
        if (wrap == null) {
            wrap = new BeanWrap(clz, bean);
        }
        return wrap;
    }

    protected void tryInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector<?> bi = this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.handler(varH, a);
        }
    }

    public void tryCreateBean(Class<?> clz) {
        Annotation[] annS = clz.getDeclaredAnnotations();
        if (annS.length > 0) {
            try {
                for (Annotation a : annS) {
                    BeanCreator<?> bc = this.beanCreators.get(a.annotationType());
                    if (bc == null) continue;
                    this.tryCreateBeanByAnno(clz, a, bc);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    protected <T extends Annotation> void tryCreateBeanByAnno(Class<?> clz, T anno, BeanCreator<T> loader) {
        try {
            BeanWrap wrap = this.wrap(clz, null);
            loader.handler(clz, wrap, anno);
            this.putWrap(clz, wrap);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void tryBuildBean(XBean anno, MethodWrap mWrap, BeanWrap bw, XInject beanInj, Function<Parameter, String> injectVal) throws Exception {
        int size2 = mWrap.getParameters().length;
        if (size2 == 0) {
            Object raw = mWrap.invoke(bw.raw(), new Object[0]);
            this.tryBuildBean0(anno, beanInj, mWrap.getReturnType(), raw);
        } else {
            ArrayList args2 = new ArrayList(size2);
            ArrayList<VarHolderParam> args1 = new ArrayList<VarHolderParam>(size2);
            for (Parameter p1 : mWrap.getParameters()) {
                VarHolderParam p2 = new VarHolderParam(p1);
                args1.add(p2);
                this.tryInjectByName(p2, injectVal.apply(p1));
            }
            XUtil.commonPool.submit(() -> {
                try {
                    for (VarHolderParam p2 : args1) {
                        args2.add(p2.getValue());
                    }
                    Object raw = mWrap.invoke(bw.raw(), args2.toArray());
                    this.tryBuildBean0(anno, beanInj, mWrap.getReturnType(), raw);
                }
                catch (Throwable ex) {
                    XEventBus.push(ex);
                }
                return true;
            });
        }
    }

    protected void tryBuildBean0(XBean anno, XInject beanInj, Class<?> clz, Object raw) {
        if (raw != null) {
            if (beanInj != null && !XUtil.isEmpty(beanInj.value()) && beanInj.value().startsWith("${")) {
                Aop.inject(raw, XApp.cfg().getPropByExpr(beanInj.value()));
            }
            XEventBus.push(raw);
            BeanWrap m_bw = new BeanWrap(clz, raw);
            m_bw.nameSet(anno.value());
            m_bw.tagSet(anno.tag());
            m_bw.attrsSet(anno.attrs());
            Aop.factory().beanRegister(m_bw, anno.value(), anno.typed());
        }
    }

    public void tryInjectByName(VarHolder varH, String name) {
        if (XUtil.isEmpty(name)) {
            Aop.getAsyn(varH.getType(), bw -> varH.setValue(bw.get()));
        } else if (name.startsWith("${classpath:")) {
            String url = name.substring(12, name.length() - 1);
            Properties val = XUtil.getProperties(XUtil.getResource(url));
            if (val == null) {
                throw new RuntimeException(name + "  failed to load!");
            }
            if (Properties.class == varH.getType()) {
                varH.setValue(val);
            } else if (Map.class == varH.getType()) {
                HashMap val2 = new HashMap();
                val.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        val2.put((String)k, (String)v);
                    }
                }));
                varH.setValue(val2);
            } else {
                Object val2 = ClassWrap.get(varH.getType()).newBy(val::getProperty);
                varH.setValue(val2);
            }
        } else if (name.startsWith("${")) {
            name = name.substring(2, name.length() - 1);
            if (Properties.class == varH.getType()) {
                XProperties val = XApp.cfg().getProp(name);
                varH.setValue(val);
            } else if (Map.class == varH.getType()) {
                XMap val = XApp.cfg().getXmap(name);
                varH.setValue(val);
            } else {
                String val = XApp.cfg().get(name);
                if (val == null) {
                    Class<?> pt = varH.getType();
                    if (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive()) {
                        varH.setValue(null);
                    } else {
                        XProperties val0 = XApp.cfg().getProp(name);
                        Object val2 = ClassWrap.get(pt).newBy(val0::getProperty);
                        varH.setValue(val2);
                    }
                } else {
                    Object val2 = TypeUtil.changeOfPop(varH.getType(), val);
                    varH.setValue(val2);
                }
            }
        } else {
            Aop.getAsyn(name, bw -> varH.setValue(bw.get()));
        }
    }
}

