/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XActionUtil;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;

public abstract class XContext {
    private boolean _handled;
    private String _protocolAsUpper;
    private String _pathAsUpper;
    private Map<String, Object> _attrMap = new HashMap<String, Object>();

    public static XContext current() {
        return XApp.currentContext();
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public boolean getHandled() {
        return this._handled;
    }

    public abstract Object request();

    public abstract String ip();

    public boolean isMultipart() {
        return this.contentType().toLowerCase().contains("multipart/");
    }

    public boolean isMultipartFormData() {
        return this.contentType().toLowerCase().contains("multipart/form-data");
    }

    public abstract String method();

    public abstract String protocol();

    public String protocolAsUpper() {
        if (this._protocolAsUpper == null) {
            this._protocolAsUpper = this.protocol().toUpperCase();
        }
        return this._protocolAsUpper;
    }

    public abstract URI uri();

    public abstract String path();

    public XMap pathMap(String expr) {
        return XUtil.pathVarMap(this.path(), expr);
    }

    public String pathAsUpper() {
        if (this._pathAsUpper == null) {
            this._pathAsUpper = this.path().toUpperCase();
        }
        return this._pathAsUpper;
    }

    public String userAgent() {
        return this.header("User-Agent");
    }

    public abstract String url();

    public abstract long contentLength();

    public abstract String contentType();

    public abstract String body() throws IOException;

    public abstract InputStream bodyAsStream() throws IOException;

    public abstract String[] paramValues(String var1);

    public abstract String param(String var1);

    public abstract String param(String var1, String var2);

    public abstract int paramAsInt(String var1);

    public int paramAsInt(String key, int def) {
        return Integer.parseInt(this.param(key, String.valueOf(def)));
    }

    public abstract long paramAsLong(String var1);

    public long paramAsLong(String key, long def) {
        return Long.parseLong(this.param(key, String.valueOf(def)));
    }

    public abstract double paramAsDouble(String var1);

    public double paramAsDouble(String key, double def) {
        return Double.parseDouble(this.param(key, String.valueOf(def)));
    }

    public abstract XMap paramMap();

    public abstract void paramSet(String var1, String var2);

    public <T> T paramAsEntity(Class<T> clz) throws Exception {
        return (T)XActionUtil.params2Entity(this, clz);
    }

    public abstract List<XFile> files(String var1) throws Exception;

    public XFile file(String key) throws Exception {
        return XUtil.firstOrNull(this.files(key));
    }

    public abstract String cookie(String var1);

    public abstract String cookie(String var1, String var2);

    public abstract XMap cookieMap();

    public abstract String header(String var1);

    public abstract String header(String var1, String var2);

    public abstract XMap headerMap();

    public abstract String sessionId();

    public abstract Object session(String var1);

    public abstract void sessionSet(String var1, Object var2);

    public abstract Object response();

    public abstract void charset(String var1);

    public abstract void contentType(String var1);

    public abstract void output(String var1) throws IOException;

    public void output(Exception ex) throws IOException {
        this.output(XUtil.getFullStackTrace(ex));
    }

    public abstract void output(InputStream var1) throws IOException;

    public abstract OutputStream outputStream() throws IOException;

    public void outputAsJson(String json) throws IOException {
        this.contentType("application/json;charset=utf-8");
        this.output(json);
    }

    public void outputAsHtml(String html) throws IOException {
        this.contentType("text/html;charset=utf-8");
        if (!html.startsWith("<")) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!doctype html>");
            sb.append("<html>");
            sb.append(html);
            sb.append("</html>");
            this.output(sb.toString());
        } else {
            this.output(html);
        }
    }

    public abstract void headerSet(String var1, String var2);

    public abstract void cookieSet(String var1, String var2, int var3);

    public abstract void cookieSet(String var1, String var2, String var3, int var4);

    public abstract void cookieSet(String var1, String var2, String var3, String var4, int var5);

    public abstract void cookieRemove(String var1);

    public abstract void redirect(String var1) throws IOException;

    public abstract void redirect(String var1, int var2) throws IOException;

    public abstract int status();

    public abstract void status(int var1) throws IOException;

    public <T> T attr(String key, T def) {
        Object val = this._attrMap.get(key);
        if (val == null) {
            return def;
        }
        return (T)val;
    }

    public void attrSet(String key, Object val) {
        this._attrMap.put(key, val);
    }

    public void attrClear() {
        this._attrMap.clear();
    }
}

