/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XPropertiesLoader;
import org.noear.solon.ext.PrintUtil;

public class ExtendLoader {
    private static final ExtendLoader _g = new ExtendLoader();
    private static String _path;

    public static String path() {
        return _path;
    }

    public static void load(String path) {
        if (!XUtil.isEmpty(path)) {
            if (path.indexOf("/") < 0) {
                path = XUtil.buildExt(path, false);
            }
            if (path != null) {
                _path = path;
                PrintUtil.blueln("solon.extend: " + path);
                File file = new File(path);
                _g.loadFile(file);
            }
        }
    }

    public static boolean loadJar(File file) {
        try {
            XClassLoader.global().loadJar(file.toURI().toURL());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean unloadJar(File file) {
        try {
            XClassLoader.global().unloadJar(file.toURI().toURL());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private ExtendLoader() {
    }

    private void loadFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.loadFileDo(tmp);
            }
        } else {
            this.loadFileDo(file);
        }
    }

    private void loadFileDo(File file) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    ExtendLoader.loadJar(file);
                    return;
                }
                if (path.endsWith(".properties")) {
                    XApp.global().prop().load(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
                if (path.endsWith(".yml")) {
                    if (!XPropertiesLoader.global.isSupport(path)) {
                        throw new RuntimeException("Do not support the *.yml");
                    }
                    XApp.global().prop().load(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

