/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.HashSet;
import java.util.Set;
import org.noear.solon.XApp;
import org.noear.solon.core.XEventListener;

public final class XEventBus {
    private static Set<HH> _sThrow = new HashSet<HH>();
    private static Set<HH> _sOther = new HashSet<HH>();

    public static void push(Object event) {
        if (event != null) {
            if (event instanceof Throwable) {
                XEventBus.push0(_sThrow, event);
                if (XApp.cfg().isDebugMode()) {
                    ((Throwable)event).printStackTrace();
                }
            } else {
                XEventBus.push0(_sOther, event);
            }
        }
    }

    private static void push0(Set<HH> hhs, Object event) {
        for (HH h1 : hhs) {
            if (!h1.t.isInstance(event)) continue;
            try {
                h1.h.onEvent(event);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public static <T> void subscribe(Class<T> eventType, XEventListener<T> handler) {
        if (Throwable.class.isAssignableFrom(eventType)) {
            _sThrow.add(new HH(eventType, handler));
        } else {
            _sOther.add(new HH(eventType, handler));
        }
    }

    static class HH {
        protected Class<?> t;
        protected XEventListener h;

        public HH(Class<?> type, XEventListener handler) {
            this.t = type;
            this.h = handler;
        }
    }
}

