/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XMapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.DataThrowable;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.PathAnalyzer;
import org.noear.solon.core.XActionUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerAide;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.RunnableEx;

public class XAction
extends XHandlerAide {
    protected final BeanWrap _bw;
    protected final MethodWrap _mw;
    protected String _produces;
    protected XRender _render;
    protected boolean _poi_main;
    private String _name;
    private boolean _remoting;
    private PathAnalyzer _pr;
    private List<String> _pks;
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public XAction(BeanWrap bw, boolean poi_main, Method m, XMapping mp, String path, boolean remoting, XRender render) {
        this._bw = bw;
        this._mw = MethodWrap.get(m);
        this._remoting = remoting;
        this._render = render;
        this._poi_main = poi_main;
        if (mp != null) {
            this._produces = mp.produces();
            this._name = mp.value();
        } else {
            this._name = m.getName();
        }
        if (path != null && path.indexOf("{") >= 0) {
            this._pks = new ArrayList<String>();
            Matcher pm = _pkr.matcher(path);
            while (pm.find()) {
                this._pks.add(pm.group(1));
            }
            if (this._pks.size() > 0) {
                this._pr = new PathAnalyzer(path);
            }
        }
    }

    public String name() {
        return this._name;
    }

    public MethodWrap method() {
        return this._mw;
    }

    public BeanWrap bean() {
        return this._bw;
    }

    public Object controller() {
        return XContext.current().attr("controller");
    }

    @Override
    public void handle(XContext x) throws Throwable {
        this.invoke(x, null);
    }

    public void invoke(XContext x, Object obj) throws Throwable {
        x.remotingSet(this._remoting);
        try {
            if (obj == null) {
                obj = this._bw.get();
            }
            if (this._poi_main) {
                x.attrSet("controller", obj);
                x.attrSet("action", this);
            }
            this.invoke0(x, obj);
        }
        catch (Throwable ex) {
            x.attrSet("error", ex);
            x.render(ex);
            XEventBus.push(ex);
        }
    }

    protected void invoke0(XContext x, Object obj) throws Throwable {
        this.handleDo(x, () -> {
            for (XHandler h : this._before) {
                h.handle(x);
            }
        });
        if (!x.getHandled()) {
            this.handleDo(x, () -> {
                Matcher pm;
                if (this._pr != null && (pm = this._pr.matcher(x.path())).find()) {
                    int len = this._pks.size();
                    for (int i = 0; i < len; ++i) {
                        x.paramSet(this._pks.get(i), pm.group(i + 1));
                    }
                }
                Object tmp = this.callDo(x, obj);
                if (this._poi_main) {
                    x.result = tmp;
                    if (!XUtil.isEmpty(this._produces)) {
                        x.contentType(this._produces);
                    }
                    this.renderDo(tmp, x);
                }
            });
        }
        for (XHandler h : this._after) {
            h.handle(x);
        }
    }

    protected void handleDo(XContext c, RunnableEx runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (DataThrowable ex) {
            c.setHandled(true);
            this.renderDo(ex, c);
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException && ex.getCause() != null) {
                ex = ex.getCause();
            }
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            c.setHandled(true);
            c.attrSet("error", ex);
            this.renderDo(ex, c);
            XEventBus.push(ex);
        }
    }

    protected Object callDo(XContext x, Object obj) throws Throwable {
        return XActionUtil.exeMethod(x, obj, this._mw);
    }

    protected void renderDo(Object result, XContext x) throws Throwable {
        if (x.getRendered()) {
            return;
        }
        x.result = result;
        if (this._render == null) {
            x.setRendered(true);
            x.render(result);
        } else {
            this._render.render(result, x);
        }
    }
}

