/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import org.noear.solon.annotation.XTran;
import org.noear.solon.core.Tran;
import org.noear.solon.core.TranFactory;
import org.noear.solon.core.TranPolicy;
import org.noear.solon.core.ValHolder;
import org.noear.solon.ext.RunnableEx;

public class TranManger {
    private static TranFactory factory;
    private static ThreadLocal<ValHolder<Tran>> rootLocal;

    public static void setFactory(TranFactory factory) {
        TranManger.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(XTran anno, RunnableEx runnable) throws Throwable {
        if (anno == null || factory == null) {
            runnable.run();
            return;
        }
        ValHolder<Tran> root = rootLocal.get();
        if (root == null) {
            if (anno.policy() == TranPolicy.supports) {
                runnable.run();
                return;
            }
            Tran tran = factory.create(anno);
            ValHolder vh = new ValHolder();
            vh.value = tran;
            vh.tag = anno.value();
            try {
                rootLocal.set(vh);
                tran.execute(runnable);
            }
            finally {
                rootLocal.remove();
            }
        } else {
            if (anno.policy() == TranPolicy.exclude) {
                Tran tran = factory.create(anno);
                tran.execute(runnable);
                return;
            }
            if (((Tran)root.value).isQueue()) {
                Tran tran = factory.create(anno);
                ((Tran)root.value).add(tran);
                tran.execute(runnable);
                return;
            }
            if (root.tag.equals(anno.value())) {
                runnable.run();
            } else {
                Tran tran = factory.create(anno);
                tran.execute(runnable);
            }
        }
    }

    static {
        rootLocal = new ThreadLocal();
    }
}

