/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.noear.solon.core.FieldWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.XContext;
import org.noear.solon.core.utils.TypeUtil;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> _cache = new ConcurrentHashMap();
    public final Class<?> clazz;
    public final List<MethodWrap> methodWraps;
    public final Map<Method, MethodWrap> methodWrapsMap;
    public final Field[] fields;
    private final Map<String, FieldWrap> fieldWrapsMap;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap l;
        ClassWrap cw = _cache.get(clz);
        if (cw == null && (l = _cache.putIfAbsent(clz, cw = new ClassWrap(clz))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this.clazz = clz;
        this.fields = clz.getDeclaredFields();
        this.methodWraps = new ArrayList<MethodWrap>();
        this.methodWrapsMap = new HashMap<Method, MethodWrap>();
        for (Method m : clz.getDeclaredMethods()) {
            MethodWrap m1 = MethodWrap.get(m);
            this.methodWraps.add(m1);
            this.methodWrapsMap.put(m, m1);
        }
        this.fieldWrapsMap = new ConcurrentHashMap<String, FieldWrap>();
        ClassWrap.scanAllFields(clz, this.fieldWrapsMap::containsKey, this.fieldWrapsMap::put);
    }

    private static void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod)) continue;
            f.setAccessible(true);
            if (checker.test(f.getName())) continue;
            consumer.accept(f.getName(), new FieldWrap(clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            ClassWrap.scanAllFields(sup, checker, consumer);
        }
    }

    public FieldWrap getFieldWrap(Field f1) {
        FieldWrap tmp = this.fieldWrapsMap.get(f1.getName());
        if (tmp == null) {
            tmp = new FieldWrap(this.clazz, f1);
            FieldWrap l = this.fieldWrapsMap.putIfAbsent(f1.getName(), tmp);
            if (l != null) {
                tmp = l;
            }
        }
        return tmp;
    }

    public MethodWrap getMethodWrap(Method m1) {
        MethodWrap l;
        MethodWrap tmp = this.methodWrapsMap.get(m1);
        if (tmp == null && (l = this.methodWrapsMap.putIfAbsent(m1, tmp = new MethodWrap(m1))) != null) {
            tmp = l;
        }
        return tmp;
    }

    public <T> T newBy(Function<String, String> data) {
        try {
            Object obj = this.clazz.newInstance();
            this.fill(obj, data, null);
            return (T)obj;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void fill(Object target, Function<String, String> data, XContext ctx) {
        for (Map.Entry<String, FieldWrap> kv : this.fieldWrapsMap.entrySet()) {
            String key = kv.getKey();
            String val0 = data.apply(key);
            if (val0 == null) continue;
            FieldWrap fw = kv.getValue();
            Object val = TypeUtil.changeOfCtx(fw.field, fw.type, key, val0, ctx);
            fw.setValue(target, val);
        }
    }
}

