/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.web.servlet.SolonServletContext;

class MultipartUtil {
    MultipartUtil() {
    }

    public static void buildParamsAndFiles(SolonServletContext context) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)context.request();
        long maxBodySize = ServerProps.request_maxBodySize > 0L ? ServerProps.request_maxBodySize : -1L;
        long maxFileSize = ServerProps.request_maxFileSize > 0L ? ServerProps.request_maxFileSize : -1L;
        MultipartConfigElement configElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"), maxFileSize, maxBodySize, 0);
        request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)configElement);
        for (Part part : request.getParts()) {
            if (!MultipartUtil.isFile(part)) continue;
            MultipartUtil.doBuildFiles(context, part);
        }
    }

    private static void doBuildFiles(SolonServletContext context, Part part) throws IOException {
        List<UploadedFile> list = context._fileMap.get(part.getName());
        if (list == null) {
            list = new ArrayList<UploadedFile>();
            context._fileMap.put(part.getName(), list);
        }
        String contentType = part.getContentType();
        long contentSize = part.getSize();
        InputStream content = part.getInputStream();
        String name = part.getSubmittedFileName();
        String extension = null;
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            extension = name.substring(idx + 1);
        }
        UploadedFile f1 = new UploadedFile(contentType, contentSize, content, name, extension);
        list.add(f1);
    }

    private static boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }

    private static boolean isFile(Part filePart) {
        return !MultipartUtil.isField(filePart);
    }
}

