/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.reactive;

import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxCompletion
implements Subscriber {
    static final Logger log = LoggerFactory.getLogger(RxCompletion.class);
    private Context ctx;

    public RxCompletion(Context ctx) {
        this.ctx = ctx;
    }

    public void onSubscribe(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(Object o) {
    }

    public void onError(Throwable throwable) {
        try {
            if (throwable instanceof StatusException) {
                StatusException status = (StatusException)throwable;
                this.ctx.status(status.getCode());
                if (status.getCode() == 404) {
                    return;
                }
            }
            log.error(throwable.getMessage(), throwable);
        }
        finally {
            this.ctx.asyncComplete();
        }
    }

    public void onComplete() {
        this.ctx.asyncComplete();
    }
}

