/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.thymeleaf;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;
import org.noear.solon.view.thymeleaf.XPluginImp;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafRender
implements XRender {
    private static ThymeleafRender _global;
    private TemplateEngine _engine = new TemplateEngine();
    private Map<String, Object> _sharedVariable = new HashMap<String, Object>();
    private String _baseUri = "/WEB-INF/view/";

    public static ThymeleafRender global() {
        if (_global == null) {
            _global = new ThymeleafRender();
        }
        return _global;
    }

    public ThymeleafRender() {
        String baseUri = XApp.global().prop().get("slon.mvc.view.prefix");
        if (!XUtil.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (XApp.cfg().isDebugMode()) {
            this.forDebug();
        } else {
            this.forRelease();
        }
        try {
            XApp.global().shared().forEach((k, v) -> this.setSharedVariable((String)k, v));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        XApp.global().onSharedAdd((k, v) -> this.setSharedVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        String dirroot = XUtil.getResource((String)"/").toString().replace("target/classes/", "");
        File dir = null;
        if (dirroot.startsWith("file:") && !(dir = new File(URI.create(dir_str = dirroot + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                FileTemplateResolver _loader = new FileTemplateResolver();
                _loader.setPrefix(dir.getAbsolutePath() + File.separatorChar);
                _loader.setTemplateMode(TemplateMode.HTML);
                _loader.setCacheable(false);
                _loader.setCharacterEncoding("utf-8");
                _loader.setCacheTTLMs(Long.valueOf(3600000L));
                this._engine.setTemplateResolver((ITemplateResolver)_loader);
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void forRelease() {
        ClassLoaderTemplateResolver _loader = new ClassLoaderTemplateResolver();
        _loader.setPrefix(this._baseUri);
        _loader.setTemplateMode(TemplateMode.HTML);
        _loader.setCacheable(true);
        _loader.setCharacterEncoding("utf-8");
        _loader.setCacheTTLMs(Long.valueOf(3600000L));
        this._engine.setTemplateResolver((ITemplateResolver)_loader);
    }

    public void setSharedVariable(String name, Object obj) {
        this._sharedVariable.put(name, obj);
    }

    public void render(Object obj, XContext ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx);
        } else {
            ctx.output(obj.toString());
        }
    }

    public void render_mav(ModelAndView mv, XContext ctx) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "ThymeleafRender");
        }
        Context context = new Context();
        context.setVariables(this._sharedVariable);
        context.setVariables((Map)mv);
        PrintWriter writer = new PrintWriter(ctx.outputStream());
        this._engine.process(mv.view(), (IContext)context, (Writer)writer);
        writer.flush();
    }
}

