/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;

public class FreemarkerRender
implements Render {
    private static FreemarkerRender _global;
    private ClassLoader classLoader;
    private Configuration provider;
    private Configuration providerOfDebug;

    public static FreemarkerRender global() {
        if (_global == null) {
            _global = new FreemarkerRender();
        }
        return _global;
    }

    public Configuration getProvider() {
        return this.provider;
    }

    public Configuration getProviderOfDebug() {
        return this.providerOfDebug;
    }

    public FreemarkerRender() {
        this((ClassLoader)JarClassLoader.global());
    }

    public FreemarkerRender(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.forDebug();
        this.forRelease();
        Solon.app().shared().forEach((k, v) -> this.putVariable((String)k, v));
        Solon.app().onSharedAdd((k, v) -> this.putVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (this.providerOfDebug != null) {
            return;
        }
        URL rooturi = ResourceUtil.getResource((String)"/");
        if (rooturi == null) {
            return;
        }
        this.providerOfDebug = new Configuration(Configuration.VERSION_2_3_28);
        this.providerOfDebug.setNumberFormat("#");
        this.providerOfDebug.setDefaultEncoding("utf-8");
        String rootdir = rooturi.toString().replace("target/classes/", "");
        File dir = null;
        if (rootdir.startsWith("file:") && !(dir = new File(URI.create(dir_str = rootdir + "src/main/resources" + ViewConfig.getViewPrefix()))).exists()) {
            dir_str = rootdir + "src/main/webapp" + ViewConfig.getViewPrefix();
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                this.providerOfDebug.setDirectoryForTemplateLoading(dir);
            }
            EventBus.publish((Object)this.providerOfDebug);
        }
        catch (Exception e) {
            EventBus.publishTry((Object)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        this.provider = new Configuration(Configuration.VERSION_2_3_28);
        this.provider.setNumberFormat("#");
        this.provider.setDefaultEncoding("utf-8");
        try {
            this.provider.setClassLoaderForTemplateLoading(this.classLoader, ViewConfig.getViewPrefix());
        }
        catch (Exception e) {
            EventBus.publishTry((Object)e);
        }
        this.provider.setCacheStorage((CacheStorage)new MruCacheStorage(0, Integer.MAX_VALUE));
        EventBus.publish((Object)this.provider);
    }

    public <T extends TemplateDirectiveModel> void putDirective(String name, T obj) {
        this.putVariable(name, obj);
    }

    public void putVariable(String name, Object value) {
        try {
            this.provider.setSharedVariable(name, value);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.setSharedVariable(name, value);
            }
        }
        catch (Exception e) {
            EventBus.publishTry((Object)e);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "FreemarkerRender");
        }
        PrintWriter writer = new PrintWriter((OutputStream)outputStream.get());
        Template template = null;
        if (this.providerOfDebug != null) {
            try {
                template = this.providerOfDebug.getTemplate(mv.view(), Solon.encoding());
            }
            catch (TemplateNotFoundException templateNotFoundException) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate(mv.view(), Solon.encoding());
        }
        template.process((Object)mv.model(), (Writer)writer);
    }
}

