/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.ext.SupplierEx;
import org.noear.solon.view.freemarker.XPluginImp;

public class FreemarkerRender
implements Render {
    private static FreemarkerRender _global;
    Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
    private String _baseUri = "/WEB-INF/view/";

    public static FreemarkerRender global() {
        if (_global == null) {
            _global = new FreemarkerRender();
        }
        return _global;
    }

    public FreemarkerRender() {
        String baseUri = Solon.cfg().get("slon.mvc.view.prefix");
        if (!Utils.isEmpty((String)baseUri)) {
            this._baseUri = baseUri;
        }
        if (Solon.cfg().isDebugMode()) {
            this.forDebug();
        } else {
            this.forRelease();
        }
        this.cfg.setNumberFormat("#");
        this.cfg.setDefaultEncoding("utf-8");
        Solon.global().onSharedAdd((k, v) -> this.setSharedVariable((String)k, v));
    }

    private void forDebug() {
        String dir_str;
        String dirroot = Utils.getResource((String)"/").toString().replace("target/classes/", "");
        File dir = null;
        if (dirroot.startsWith("file:") && !(dir = new File(URI.create(dir_str = dirroot + "src/main/resources" + this._baseUri))).exists()) {
            dir_str = dirroot + "src/main/webapp" + this._baseUri;
            dir = new File(URI.create(dir_str));
        }
        try {
            if (dir != null && dir.exists()) {
                this.cfg.setDirectoryForTemplateLoading(dir);
            } else {
                this.forRelease();
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    private void forRelease() {
        try {
            this.cfg.setClassLoaderForTemplateLoading((ClassLoader)JarClassLoader.global(), this._baseUri);
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
        this.cfg.setCacheStorage((CacheStorage)new MruCacheStorage(0, Integer.MAX_VALUE));
    }

    public void setSharedVariable(String name, Object value) {
        try {
            this.cfg.setSharedVariable(name, value);
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=utf-8");
        }
        if (XPluginImp.output_meta) {
            ctx.headerSet("solon.view", "FreemarkerRender");
        }
        PrintWriter writer = new PrintWriter((OutputStream)outputStream.get());
        Template template = this.cfg.getTemplate(mv.view(), "utf-8");
        template.process((Object)mv.model(), (Writer)writer);
    }
}

