/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import java.io.Writer;

public class NoLockStringWriter
extends Writer {
    protected char[] buf = new char[64];
    protected int count;

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = NoLockStringWriter.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(cbuf, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    public void write(String str) throws IOException {
        if (str != null) {
            this.write(str.toCharArray());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }
}

