/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.vault;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.vault.VaultCoder;
import org.noear.solon.vault.coder.AesVaultCoder;

public class VaultUtils {
    public static final String TAG_PREFIX = "ENC(";
    public static final String TAG_SUFFIX = ")";
    static VaultCoder guardCoder = new AesVaultCoder();

    public static boolean isEncrypted(String str) {
        if (str == null) {
            return false;
        }
        return str.startsWith(TAG_PREFIX) && str.endsWith(TAG_SUFFIX);
    }

    public static String encrypt(String str) {
        if (Utils.isEmpty((String)str)) {
            return str;
        }
        try {
            String tmp = guardCoder.encrypt(str);
            return TAG_PREFIX + tmp + TAG_SUFFIX;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String str) {
        if (Utils.isEmpty((String)str)) {
            return str;
        }
        try {
            str = str.substring(TAG_PREFIX.length(), str.length() - TAG_SUFFIX.length());
            return guardCoder.decrypt(str);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Solon.context().getWrapAsync(VaultCoder.class, bw -> {
            guardCoder = (VaultCoder)bw.get();
        });
    }
}

