/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.DecimalMax;
import org.noear.solon.validation.util.StringUtils;

public class DecimalMaxValidator
implements Validator<DecimalMax> {
    public static final DecimalMaxValidator instance = new DecimalMaxValidator();

    @Override
    public String message(DecimalMax anno) {
        return anno.message();
    }

    @Override
    public Result validateOfValue(DecimalMax anno, Object val0, StringBuilder tmp) {
        if (!(val0 instanceof Double)) {
            return Result.failure();
        }
        Double val = (Double)val0;
        if (val == null || val > anno.value()) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, DecimalMax anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!StringUtils.isNumber(val) || Double.parseDouble(val) > anno.value()) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }
}

