/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Min;
import org.noear.solon.validation.util.StringUtils;

public class MinValidator
implements Validator<Min> {
    public static final MinValidator instance = new MinValidator();

    @Override
    public String message(Min anno) {
        return anno.message();
    }

    @Override
    public Result validateOfValue(String label, Min anno, Object val0, StringBuilder tmp) {
        if (!(val0 instanceof Number)) {
            return Result.failure((String)label);
        }
        Number val = (Number)val0;
        if (val == null || val.longValue() < anno.value()) {
            return Result.failure((String)label);
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Min anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!StringUtils.isInteger(val) || Long.parseLong(val) < anno.value()) {
            tmp.append(',').append(name);
        }
        if (tmp.length() > 1) {
            return Result.failure((String)tmp.substring(1));
        }
        return Result.succeed();
    }
}

