/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Email;

public class EmailValidator
implements Validator<Email> {
    private static final Map<String, Pattern> cached = new ConcurrentHashMap<String, Pattern>();
    public static final EmailValidator instance = new EmailValidator();

    public EmailValidator() {
        cached.putIfAbsent("", Pattern.compile("^[a-z]([a-z0-9]*[-_]?[a-z0-9]+)*@([a-z0-9]*[-_]?[a-z0-9]+)+[\\.][a-z]{2,3}([\\.][a-z]{2})?$"));
    }

    @Override
    public String message(Email anno) {
        return anno.message();
    }

    @Override
    public Result validate(Context ctx, Email anno, String name, StringBuilder tmp) {
        String val;
        Pattern pt = cached.get(anno.value());
        if (pt == null) {
            if (!anno.value().contains("@")) {
                throw new RuntimeException("@Email value must have an @ sign");
            }
            pt = Pattern.compile(anno.value());
            cached.putIfAbsent(anno.value(), pt);
        }
        if ((val = ctx.param(name)) == null || !pt.matcher(val).find()) {
            tmp.append(',').append(name);
        }
        if (tmp.length() > 1) {
            return Result.failure((String)tmp.substring(1));
        }
        return Result.succeed();
    }
}

