/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.validation.BeanValidateInfo;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.ValidatorFailureHandler;
import org.noear.solon.validation.ValidatorFailureHandlerDefault;
import org.noear.solon.validation.annotation.Date;
import org.noear.solon.validation.annotation.DateValidator;
import org.noear.solon.validation.annotation.DecimalMax;
import org.noear.solon.validation.annotation.DecimalMaxValidator;
import org.noear.solon.validation.annotation.DecimalMin;
import org.noear.solon.validation.annotation.DecimalMinValidator;
import org.noear.solon.validation.annotation.Email;
import org.noear.solon.validation.annotation.EmailValidator;
import org.noear.solon.validation.annotation.Length;
import org.noear.solon.validation.annotation.LengthValidator;
import org.noear.solon.validation.annotation.Logined;
import org.noear.solon.validation.annotation.LoginedChecker;
import org.noear.solon.validation.annotation.LoginedValidator;
import org.noear.solon.validation.annotation.Max;
import org.noear.solon.validation.annotation.MaxValidator;
import org.noear.solon.validation.annotation.Min;
import org.noear.solon.validation.annotation.MinValidator;
import org.noear.solon.validation.annotation.NoRepeatSubmit;
import org.noear.solon.validation.annotation.NoRepeatSubmitChecker;
import org.noear.solon.validation.annotation.NoRepeatSubmitValidator;
import org.noear.solon.validation.annotation.NotBlacklist;
import org.noear.solon.validation.annotation.NotBlacklistChecker;
import org.noear.solon.validation.annotation.NotBlacklistValidator;
import org.noear.solon.validation.annotation.NotBlank;
import org.noear.solon.validation.annotation.NotBlankValidator;
import org.noear.solon.validation.annotation.NotEmpty;
import org.noear.solon.validation.annotation.NotEmptyValidator;
import org.noear.solon.validation.annotation.NotNull;
import org.noear.solon.validation.annotation.NotNullValidator;
import org.noear.solon.validation.annotation.NotZero;
import org.noear.solon.validation.annotation.NotZeroValidator;
import org.noear.solon.validation.annotation.Null;
import org.noear.solon.validation.annotation.NullValidator;
import org.noear.solon.validation.annotation.Numeric;
import org.noear.solon.validation.annotation.NumericValidator;
import org.noear.solon.validation.annotation.Pattern;
import org.noear.solon.validation.annotation.PatternValidator;
import org.noear.solon.validation.annotation.Range;
import org.noear.solon.validation.annotation.RangeValidator;
import org.noear.solon.validation.annotation.Size;
import org.noear.solon.validation.annotation.SizeValidator;
import org.noear.solon.validation.annotation.Validated;
import org.noear.solon.validation.annotation.ValidatedValidator;
import org.noear.solon.validation.annotation.Whitelist;
import org.noear.solon.validation.annotation.WhitelistChecker;
import org.noear.solon.validation.annotation.WhitelistValidator;

public class ValidatorManager {
    private static final Map<Class<? extends Annotation>, Validator> validMap = new HashMap<Class<? extends Annotation>, Validator>();
    private static ValidatorFailureHandler failureHandler = new ValidatorFailureHandlerDefault();

    public static void setNoRepeatSubmitChecker(NoRepeatSubmitChecker checker) {
        NoRepeatSubmitValidator.instance.setChecker(checker);
    }

    public static void setLoginedChecker(LoginedChecker checker) {
        LoginedValidator.instance.setChecker(checker);
    }

    public static void setWhitelistChecker(WhitelistChecker checker) {
        WhitelistValidator.instance.setChecker(checker);
    }

    public static void setNotBlacklistChecker(NotBlacklistChecker checker) {
        NotBlacklistValidator.instance.setChecker(checker);
    }

    public static void setFailureHandler(ValidatorFailureHandler handler) {
        if (handler != null) {
            failureHandler = handler;
        }
    }

    private static void initialize() {
        ValidatorManager.register(Date.class, DateValidator.instance);
        ValidatorManager.register(DecimalMax.class, DecimalMaxValidator.instance);
        ValidatorManager.register(DecimalMin.class, DecimalMinValidator.instance);
        ValidatorManager.register(Email.class, EmailValidator.instance);
        ValidatorManager.register(Max.class, MaxValidator.instance);
        ValidatorManager.register(Min.class, MinValidator.instance);
        ValidatorManager.register(NoRepeatSubmit.class, NoRepeatSubmitValidator.instance);
        ValidatorManager.register(NotBlank.class, NotBlankValidator.instance);
        ValidatorManager.register(NotEmpty.class, NotEmptyValidator.instance);
        ValidatorManager.register(NotNull.class, NotNullValidator.instance);
        ValidatorManager.register(NotZero.class, NotZeroValidator.instance);
        ValidatorManager.register(Null.class, NullValidator.instance);
        ValidatorManager.register(Numeric.class, NumericValidator.instance);
        ValidatorManager.register(Pattern.class, PatternValidator.instance);
        ValidatorManager.register(Length.class, LengthValidator.instance);
        ValidatorManager.register(Size.class, SizeValidator.instance);
        ValidatorManager.register(Range.class, RangeValidator.instance);
        ValidatorManager.register(Whitelist.class, WhitelistValidator.instance);
        ValidatorManager.register(Logined.class, LoginedValidator.instance);
        ValidatorManager.register(NotBlacklist.class, NotBlacklistValidator.instance);
        ValidatorManager.register(Validated.class, ValidatedValidator.instance);
    }

    @Note(value="\u6e05\u9664\u6240\u6709\u9a8c\u8bc1\u5668")
    public static void clear() {
        validMap.clear();
    }

    @Note(value="\u79fb\u9664\u67d0\u4e2a\u7c7b\u578b\u7684\u9a8c\u8bc1\u5668")
    public static <T extends Annotation> void remove(Class<T> type) {
        validMap.remove(type);
    }

    @Note(value="\u6ce8\u518c\u9a8c\u8bc1\u5668")
    public static <T extends Annotation> void register(Class<T> type, Validator<T> validator) {
        validMap.put(type, validator);
    }

    @Note(value="\u79fb\u9664\u67d0\u4e2a\u7c7b\u578b\u7684\u9a8c\u8bc1\u5668")
    public static <T extends Annotation> Validator<T> get(Class<T> type) {
        return validMap.get(type);
    }

    @Note(value="\u6267\u884c\u4e0a\u4e0b\u6587\u7684\u9a8c\u8bc1\u5904\u7406")
    public static void validateOfContext(Context ctx, Action action) throws Throwable {
        StringBuilder tmp = new StringBuilder();
        for (Annotation anno : action.controller().annotations()) {
            if (!ValidatorManager.validateOfContext0(ctx, anno, null, tmp)) continue;
            return;
        }
        for (Annotation anno : action.method().getAnnotations()) {
            if (!ValidatorManager.validateOfContext0(ctx, anno, null, tmp)) continue;
            return;
        }
    }

    private static boolean validateOfContext0(Context ctx, Annotation anno, String name, StringBuilder tmp) {
        if (ctx.getHandled()) {
            return true;
        }
        Validator valid = validMap.get(anno.annotationType());
        if (valid != null) {
            tmp.setLength(0);
            Result rst = valid.validateOfContext(ctx, anno, name, tmp);
            if (rst.getCode() != Result.SUCCEED_CODE && ValidatorManager.failureDo(ctx, anno, rst, valid.message(anno))) {
                return true;
            }
        }
        return false;
    }

    @Note(value="\u6267\u884c\u53c2\u6570\u7684\u9a8c\u8bc1\u5904\u7406")
    public static void validateOfInvocation(Invocation inv) throws Throwable {
        StringBuilder tmp = new StringBuilder();
        int len = inv.args().length;
        for (int i = 0; i < len; ++i) {
            ParamWrap pw = inv.method().getParamWraps()[i];
            for (Annotation anno : pw.getParameter().getAnnotations()) {
                ValidatorManager.validateOfValue0(pw.getName(), anno, inv.args()[i], tmp);
            }
        }
    }

    private static void validateOfValue0(String label, Annotation anno, Object val, StringBuilder tmp) {
        Validator valid = validMap.get(anno.annotationType());
        if (valid != null) {
            tmp.setLength(0);
            Result rst = valid.validateOfValue(anno, val, tmp);
            if (rst.getCode() == Result.FAILURE_CODE) {
                String message = null;
                if (Utils.isEmpty((String)rst.getDescription())) {
                    rst.setDescription(label);
                }
                if (rst.getData() instanceof BeanValidateInfo) {
                    BeanValidateInfo info = (BeanValidateInfo)((Object)rst.getData());
                    anno = info.anno;
                    message = info.message;
                } else {
                    message = valid.message(anno);
                }
                if (ValidatorManager.failureDo(Context.current(), anno, rst, message)) {
                    throw new DataThrowable();
                }
                throw new IllegalArgumentException(rst.getDescription());
            }
        }
    }

    @Note(value="\u6267\u884c\u5b9e\u4f53\u7684\u9a8c\u8bc1\u5904\u7406")
    public static Result validateOfEntity(Object obj, Class<?>[] groups) {
        try {
            if (obj instanceof Collection) {
                return ValidatorManager.validateOfEntityAry(obj, groups);
            }
            if (obj instanceof Map) {
                return ValidatorManager.validateOfEntityMap(obj, groups);
            }
            return ValidatorManager.validateOfEntityOne(obj, groups);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Result validateOfEntityAry(Object obj, Class<?>[] groups) {
        for (Object val2 : (Collection)obj) {
            Result rst;
            if (val2 == null || (rst = ValidatorManager.validateOfEntity(val2, groups)).getCode() == Result.SUCCEED_CODE) continue;
            return rst;
        }
        return Result.succeed();
    }

    private static Result validateOfEntityMap(Object obj, Class<?>[] groups) {
        for (Object val2 : ((Map)obj).values()) {
            Result rst;
            if (val2 == null || (rst = ValidatorManager.validateOfEntity(val2, groups)).getCode() == Result.SUCCEED_CODE) continue;
            return rst;
        }
        return Result.succeed();
    }

    private static Result validateOfEntityOne(Object obj, Class<?>[] groups) throws IllegalAccessException {
        if (obj == null) {
            return Result.succeed();
        }
        ClassWrap cw = ClassWrap.get(obj.getClass());
        StringBuilder tmp = new StringBuilder();
        for (Map.Entry kv : cw.getFieldAllWraps().entrySet()) {
            Field field = ((FieldWrap)kv.getValue()).field;
            for (Annotation anno : ((FieldWrap)kv.getValue()).annoS) {
                Validator<? extends Annotation> valid = ValidatorManager.get(anno.annotationType());
                if (valid == null || !ValidatorManager.inGroup(valid.groups(anno), groups)) continue;
                tmp.setLength(0);
                Result rst = valid.validateOfValue(anno, field.get(obj), tmp);
                if (rst.getCode() == Result.SUCCEED_CODE) continue;
                if (Utils.isEmpty((String)rst.getDescription())) {
                    rst.setDescription(cw.clz().getSimpleName() + "." + field.getName());
                }
                if (!(rst.getData() instanceof BeanValidateInfo)) {
                    rst.setData((Object)new BeanValidateInfo(anno, valid.message(anno)));
                }
                return rst;
            }
        }
        return Result.succeed();
    }

    @Note(value="\u6267\u884c\u9519\u8bef\u5904\u7406")
    public static boolean failureDo(Context ctx, Annotation ano, Result result, String message) {
        if (ctx == null) {
            return false;
        }
        try {
            return failureHandler.onFailure(ctx, ano, result, message);
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private static boolean inGroup(Class<?>[] annoGroups, Class<?>[] groups) {
        if (annoGroups == null || annoGroups.length == 0) {
            return true;
        }
        if (groups == null || groups.length == 0) {
            return false;
        }
        for (Class<?> g1 : groups) {
            for (Class<?> g2 : annoGroups) {
                if (g1 != g2) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ValidatorManager.initialize();
    }
}

