/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.jackson.JacksonRenderFactoryBase;
import org.noear.solon.serialization.jackson.JacksonStringSerializer;

public class JacksonRenderFactory
extends JacksonRenderFactoryBase {
    private ObjectMapper config = new ObjectMapper();
    private Set<SerializationFeature> features = new HashSet<SerializationFeature>();

    public JacksonRenderFactory() {
        this.features.add(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.config.registerModule((Module)new JavaTimeModule());
    }

    public Render create() {
        this.registerModule();
        for (SerializationFeature f1 : this.features) {
            this.config.enable(f1);
        }
        JacksonStringSerializer serializer = new JacksonStringSerializer();
        serializer.setConfig(this.config);
        return new StringSerializerRender(false, (ContextSerializer)serializer);
    }

    @Override
    public ObjectMapper config() {
        return this.config;
    }

    public void setFeatures(SerializationFeature ... features) {
        this.features.clear();
        this.features.addAll(Arrays.asList(features));
    }

    public void addFeatures(SerializationFeature ... features) {
        this.features.addAll(Arrays.asList(features));
    }

    public void removeFeatures(SerializationFeature ... features) {
        this.features.removeAll(Arrays.asList(features));
    }
}

