/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.noear.solon.serialization.JsonLongConverter;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.JsonStringConverter;

public abstract class JacksonRenderFactoryBase
implements JsonRenderFactory {
    protected SimpleModule module;

    protected abstract ObjectMapper config();

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        if (this.module == null) {
            this.module = new SimpleModule();
            this.config().registerModule((Module)this.module);
        }
        this.module.addSerializer(clz, encoder);
    }

    public <T> void addConvertor(Class<T> clz, final JsonLongConverter<T> converter) {
        this.addEncoder(clz, new JsonSerializer<T>(){

            public void serialize(T source, JsonGenerator gen, SerializerProvider sp) throws IOException {
                gen.writeNumber(converter.convert(source).longValue());
            }
        });
    }

    public <T> void addConvertor(Class<T> clz, final JsonStringConverter<T> converter) {
        this.addEncoder(clz, new JsonSerializer<T>(){

            public void serialize(T source, JsonGenerator gen, SerializerProvider sp) throws IOException {
                gen.writeString(converter.convert(source));
            }
        });
    }
}

