/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.serialization.ActionSerializer;

public class GsonStringSerializer
implements ActionSerializer<String> {
    private GsonBuilder config;
    private Gson _gson;

    public GsonBuilder getConfig() {
        if (this.config == null) {
            this.config = new GsonBuilder();
        }
        return this.config;
    }

    public void refresh() {
        this._gson = this.getConfig().create();
    }

    public Gson getGson() {
        if (this._gson == null) {
            Utils.locker().lock();
            try {
                if (this._gson == null) {
                    this._gson = this.config.create();
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this._gson;
    }

    public String name() {
        return "gson-json";
    }

    public String serialize(Object obj) throws IOException {
        return this.getGson().toJson(obj);
    }

    public Object deserialize(String data, Class<?> clz) throws IOException {
        if (clz == null) {
            return JsonParser.parseString((String)data);
        }
        JsonElement jsonElement = JsonParser.parseString((String)data);
        return this.getGson().fromJson(jsonElement, clz);
    }

    public Object deserializeBody(Context ctx) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return JsonParser.parseString((String)data);
        }
        return null;
    }
}

