/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.serialization.JsonRenderFactory;

public abstract class GsonRenderFactoryBase
implements JsonRenderFactory {
    public abstract GsonBuilder config();

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.config().registerTypeAdapter(clz, encoder);
    }

    public <T> void addConvertor(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (source, type, jsc) -> {
            Object val = converter.convert(source);
            if (val == null) {
                return JsonNull.INSTANCE;
            }
            if (val instanceof String) {
                return new JsonPrimitive((String)val);
            }
            if (val instanceof Number) {
                return new JsonPrimitive((Number)val);
            }
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        });
    }
}

